/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.db.DatabaseRecord;
import com.maxmind.db.Network;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.model.AbstractResponse;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IspResponse;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import com.maxmind.geoip2.record.Subdivision;
import com.maxmind.geoip2.record.Traits;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.geoip.Database;
import org.elasticsearch.ingest.geoip.IpDataLookup;
import org.elasticsearch.ingest.geoip.IpDatabase;

final class MaxmindIpDataLookups {
    private static final Logger logger = LogManager.getLogger(MaxmindIpDataLookups.class);
    static final String GEOIP2_PREFIX = "GeoIP2".toLowerCase(Locale.ROOT);
    static final String GEOLITE2_PREFIX = "GeoLite2".toLowerCase(Locale.ROOT);
    private static final String CITY_DB_SUFFIX = "-City";
    private static final String COUNTRY_DB_SUFFIX = "-Country";
    private static final String ASN_DB_SUFFIX = "-ASN";
    private static final String ANONYMOUS_IP_DB_SUFFIX = "-Anonymous-IP";
    private static final String CONNECTION_TYPE_DB_SUFFIX = "-Connection-Type";
    private static final String DOMAIN_DB_SUFFIX = "-Domain";
    private static final String ENTERPRISE_DB_SUFFIX = "-Enterprise";
    private static final String ISP_DB_SUFFIX = "-ISP";

    private MaxmindIpDataLookups() {
    }

    @Nullable
    static Database getMaxmindDatabase(String databaseType) {
        if (databaseType.endsWith(CITY_DB_SUFFIX)) {
            return Database.City;
        }
        if (databaseType.endsWith(COUNTRY_DB_SUFFIX)) {
            return Database.Country;
        }
        if (databaseType.endsWith(ASN_DB_SUFFIX)) {
            return Database.Asn;
        }
        if (databaseType.endsWith(ANONYMOUS_IP_DB_SUFFIX)) {
            return Database.AnonymousIp;
        }
        if (databaseType.endsWith(CONNECTION_TYPE_DB_SUFFIX)) {
            return Database.ConnectionType;
        }
        if (databaseType.endsWith(DOMAIN_DB_SUFFIX)) {
            return Database.Domain;
        }
        if (databaseType.endsWith(ENTERPRISE_DB_SUFFIX)) {
            return Database.Enterprise;
        }
        if (databaseType.endsWith(ISP_DB_SUFFIX)) {
            return Database.Isp;
        }
        logger.trace("returning null for unsupported database_type [{}]", (Object)databaseType);
        return null;
    }

    @Nullable
    static Function<Set<Database.Property>, IpDataLookup> getMaxmindLookup(Database database) {
        return switch (database) {
            case Database.City -> City::new;
            case Database.Country -> Country::new;
            case Database.Asn -> Asn::new;
            case Database.AnonymousIp -> AnonymousIp::new;
            case Database.ConnectionType -> ConnectionType::new;
            case Database.Domain -> Domain::new;
            case Database.Enterprise -> Enterprise::new;
            case Database.Isp -> Isp::new;
            default -> null;
        };
    }

    @Nullable
    private static Boolean isInEuropeanUnion(com.maxmind.geoip2.record.Country country) {
        return country.getIsoCode() == null ? null : Boolean.valueOf(country.isInEuropeanUnion());
    }

    @Nullable
    private static String regionIsoCode(com.maxmind.geoip2.record.Country country, Subdivision subdivision) {
        String countryIso = country.getIsoCode();
        String subdivisionIso = subdivision.getIsoCode();
        if (countryIso != null && subdivisionIso != null) {
            return countryIso + "-" + subdivisionIso;
        }
        return null;
    }

    private static abstract class AbstractBase<RESPONSE extends AbstractResponse, RECORD>
    implements IpDataLookup {
        protected final Set<Database.Property> properties;
        protected final Class<RESPONSE> clazz;
        protected final ResponseBuilder<RESPONSE> builder;

        AbstractBase(Set<Database.Property> properties, Class<RESPONSE> clazz, ResponseBuilder<RESPONSE> builder) {
            this.properties = Set.copyOf(properties);
            this.clazz = clazz;
            this.builder = builder;
        }

        @Override
        public Set<Database.Property> getProperties() {
            return this.properties;
        }

        @Override
        public final Map<String, Object> getData(IpDatabase ipDatabase, String ipAddress) {
            Object response = ipDatabase.getResponse(ipAddress, this::lookup);
            return response == null ? Map.of() : this.transform(response);
        }

        @Nullable
        private RECORD lookup(Reader reader, String ipAddress) throws IOException {
            InetAddress ip = InetAddresses.forString((String)ipAddress);
            DatabaseRecord entry = reader.getRecord(ip, this.clazz);
            AbstractResponse data = (AbstractResponse)entry.getData();
            return data == null ? null : (RECORD)this.cacheableRecord(this.builder.build(data, NetworkAddress.format((InetAddress)ip), entry.getNetwork(), List.of("en")));
        }

        protected abstract RECORD cacheableRecord(RESPONSE var1);

        protected abstract Map<String, Object> transform(RECORD var1);
    }

    @FunctionalInterface
    private static interface ResponseBuilder<RESPONSE extends AbstractResponse> {
        public RESPONSE build(RESPONSE var1, String var2, Network var3, List<String> var4);
    }

    static class Isp
    extends AbstractBase<IspResponse, IspResponse> {
        Isp(Set<Database.Property> properties) {
            super(properties, IspResponse.class, (response, ipAddress, network, locales) -> new IspResponse(response, ipAddress, network));
        }

        @Override
        protected IspResponse cacheableRecord(IspResponse response) {
            return response;
        }

        @Override
        protected Map<String, Object> transform(IspResponse response) {
            String isp = response.getIsp();
            String ispOrganization = response.getOrganization();
            String mobileNetworkCode = response.getMobileNetworkCode();
            String mobileCountryCode = response.getMobileCountryCode();
            Long asn = response.getAutonomousSystemNumber();
            String organizationName = response.getAutonomousSystemOrganization();
            Network network = response.getNetwork();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network.toString());
                        break;
                    }
                    case ISP: {
                        if (isp == null) break;
                        data.put("isp", isp);
                        break;
                    }
                    case ISP_ORGANIZATION_NAME: {
                        if (ispOrganization == null) break;
                        data.put("isp_organization_name", ispOrganization);
                        break;
                    }
                    case MOBILE_COUNTRY_CODE: {
                        if (mobileCountryCode == null) break;
                        data.put("mobile_country_code", mobileCountryCode);
                        break;
                    }
                    case MOBILE_NETWORK_CODE: {
                        if (mobileNetworkCode == null) break;
                        data.put("mobile_network_code", mobileNetworkCode);
                    }
                }
            }
            return data;
        }
    }

    static class Enterprise
    extends AbstractBase<EnterpriseResponse, IpDataLookup.Result<CacheableEnterpriseResponse>> {
        Enterprise(Set<Database.Property> properties) {
            super(properties, EnterpriseResponse.class, EnterpriseResponse::new);
        }

        @Override
        protected IpDataLookup.Result<CacheableEnterpriseResponse> cacheableRecord(EnterpriseResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            Continent continent = response.getContinent();
            Subdivision subdivision = response.getMostSpecificSubdivision();
            com.maxmind.geoip2.record.City city = response.getCity();
            Location location = response.getLocation();
            Postal postal = response.getPostal();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            Traits traits = response.getTraits();
            return new IpDataLookup.Result<CacheableEnterpriseResponse>(new CacheableEnterpriseResponse(country.getConfidence(), MaxmindIpDataLookups.isInEuropeanUnion(country), country.getIsoCode(), country.getName(), continent.getCode(), continent.getName(), MaxmindIpDataLookups.regionIsoCode(country, subdivision), subdivision.getName(), city.getConfidence(), city.getName(), location.getTimeZone(), location.getLatitude(), location.getLongitude(), location.getAccuracyRadius(), postal.getCode(), postal.getConfidence(), traits.getAutonomousSystemNumber(), traits.getAutonomousSystemOrganization(), traits.isHostingProvider(), traits.isTorExitNode(), traits.isAnonymousVpn(), traits.isAnonymous(), traits.isPublicProxy(), traits.isResidentialProxy(), traits.getDomain(), traits.getIsp(), traits.getOrganization(), traits.getMobileCountryCode(), traits.getMobileNetworkCode(), traits.getUserType(), traits.getConnectionType() == null ? null : traits.getConnectionType().toString(), MaxmindIpDataLookups.isInEuropeanUnion(registeredCountry), registeredCountry.getIsoCode(), registeredCountry.getName()), traits.getIpAddress(), traits.getNetwork().toString());
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<CacheableEnterpriseResponse> result) {
            CacheableEnterpriseResponse response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block37: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case COUNTRY_CONFIDENCE: {
                        if (response.countryConfidence == null) break;
                        data.put("country_confidence", response.countryConfidence);
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.isInEuropeanUnion == null) break;
                        data.put("country_in_european_union", response.isInEuropeanUnion);
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        if (response.countryIsoCode == null) break;
                        data.put("country_iso_code", response.countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        if (response.countryName == null) break;
                        data.put("country_name", response.countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        if (response.continentCode == null) break;
                        data.put("continent_code", response.continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        if (response.continentName == null) break;
                        data.put("continent_name", response.continentName);
                        break;
                    }
                    case REGION_ISO_CODE: {
                        if (response.regionIsoCode == null) break;
                        data.put("region_iso_code", response.regionIsoCode);
                        break;
                    }
                    case REGION_NAME: {
                        if (response.regionName == null) break;
                        data.put("region_name", response.regionName);
                        break;
                    }
                    case CITY_CONFIDENCE: {
                        if (response.cityConfidence == null) break;
                        data.put("city_confidence", response.cityConfidence);
                        break;
                    }
                    case CITY_NAME: {
                        if (response.cityName == null) break;
                        data.put("city_name", response.cityName);
                        break;
                    }
                    case TIMEZONE: {
                        if (response.timezone == null) break;
                        data.put("timezone", response.timezone);
                        break;
                    }
                    case LOCATION: {
                        Double latitude = response.latitude;
                        Double longitude = response.longitude;
                        if (latitude == null || longitude == null) continue block37;
                        HashMap<String, Double> locationObject = new HashMap<String, Double>();
                        locationObject.put("lat", latitude);
                        locationObject.put("lon", longitude);
                        data.put("location", locationObject);
                        break;
                    }
                    case ACCURACY_RADIUS: {
                        if (response.accuracyRadius == null) break;
                        data.put("accuracy_radius", response.accuracyRadius);
                        break;
                    }
                    case POSTAL_CODE: {
                        if (response.postalCode == null) break;
                        data.put("postal_code", response.postalCode);
                        break;
                    }
                    case POSTAL_CONFIDENCE: {
                        if (response.postalConfidence == null) break;
                        data.put("postal_confidence", response.postalConfidence);
                        break;
                    }
                    case ASN: {
                        if (response.asn == null) break;
                        data.put("asn", response.asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (response.organizationName == null) break;
                        data.put("organization_name", response.organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (result.network() == null) break;
                        data.put("network", result.network());
                        break;
                    }
                    case HOSTING_PROVIDER: {
                        data.put("hosting_provider", response.isHostingProvider);
                        break;
                    }
                    case TOR_EXIT_NODE: {
                        data.put("tor_exit_node", response.isTorExitNode);
                        break;
                    }
                    case ANONYMOUS_VPN: {
                        data.put("anonymous_vpn", response.isAnonymousVpn);
                        break;
                    }
                    case ANONYMOUS: {
                        data.put("anonymous", response.isAnonymous);
                        break;
                    }
                    case PUBLIC_PROXY: {
                        data.put("public_proxy", response.isPublicProxy);
                        break;
                    }
                    case RESIDENTIAL_PROXY: {
                        data.put("residential_proxy", response.isResidentialProxy);
                        break;
                    }
                    case DOMAIN: {
                        if (response.domain == null) break;
                        data.put("domain", response.domain);
                        break;
                    }
                    case ISP: {
                        if (response.isp == null) break;
                        data.put("isp", response.isp);
                        break;
                    }
                    case ISP_ORGANIZATION_NAME: {
                        if (response.ispOrganization == null) break;
                        data.put("isp_organization_name", response.ispOrganization);
                        break;
                    }
                    case MOBILE_COUNTRY_CODE: {
                        if (response.mobileCountryCode == null) break;
                        data.put("mobile_country_code", response.mobileCountryCode);
                        break;
                    }
                    case MOBILE_NETWORK_CODE: {
                        if (response.mobileNetworkCode == null) break;
                        data.put("mobile_network_code", response.mobileNetworkCode);
                        break;
                    }
                    case USER_TYPE: {
                        if (response.userType == null) break;
                        data.put("user_type", response.userType);
                        break;
                    }
                    case CONNECTION_TYPE: {
                        if (response.connectionType == null) break;
                        data.put("connection_type", response.connectionType);
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.registeredCountryIsInEuropeanUnion == null) break;
                        data.put("registered_country_in_european_union", response.registeredCountryIsInEuropeanUnion);
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (response.registeredCountryIsoCode == null) break;
                        data.put("registered_country_iso_code", response.registeredCountryIsoCode);
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (response.registeredCountryName == null) break;
                        data.put("registered_country_name", response.registeredCountryName);
                    }
                }
            }
            return data;
        }
    }

    record CacheableEnterpriseResponse(Integer countryConfidence, Boolean isInEuropeanUnion, String countryIsoCode, String countryName, String continentCode, String continentName, String regionIsoCode, String regionName, Integer cityConfidence, String cityName, String timezone, Double latitude, Double longitude, Integer accuracyRadius, String postalCode, Integer postalConfidence, Long asn, String organizationName, boolean isHostingProvider, boolean isTorExitNode, boolean isAnonymousVpn, boolean isAnonymous, boolean isPublicProxy, boolean isResidentialProxy, String domain, String isp, String ispOrganization, String mobileCountryCode, String mobileNetworkCode, String userType, String connectionType, Boolean registeredCountryIsInEuropeanUnion, String registeredCountryIsoCode, String registeredCountryName) {
    }

    static class Domain
    extends AbstractBase<DomainResponse, DomainResponse> {
        Domain(Set<Database.Property> properties) {
            super(properties, DomainResponse.class, (response, ipAddress, network, locales) -> new DomainResponse(response, ipAddress, network));
        }

        @Override
        protected DomainResponse cacheableRecord(DomainResponse response) {
            return response;
        }

        @Override
        protected Map<String, Object> transform(DomainResponse response) {
            String domain = response.getDomain();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case DOMAIN: {
                        if (domain == null) break;
                        data.put("domain", domain);
                    }
                }
            }
            return data;
        }
    }

    static class Country
    extends AbstractBase<CountryResponse, IpDataLookup.Result<CacheableCountryResponse>> {
        Country(Set<Database.Property> properties) {
            super(properties, CountryResponse.class, CountryResponse::new);
        }

        @Override
        protected IpDataLookup.Result<CacheableCountryResponse> cacheableRecord(CountryResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            Continent continent = response.getContinent();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            Traits traits = response.getTraits();
            return new IpDataLookup.Result<CacheableCountryResponse>(new CacheableCountryResponse(MaxmindIpDataLookups.isInEuropeanUnion(country), country.getIsoCode(), country.getName(), continent.getCode(), continent.getName(), MaxmindIpDataLookups.isInEuropeanUnion(registeredCountry), registeredCountry.getIsoCode(), registeredCountry.getName()), traits.getIpAddress(), traits.getNetwork().toString());
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<CacheableCountryResponse> result) {
            CacheableCountryResponse response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.isInEuropeanUnion == null) break;
                        data.put("country_in_european_union", response.isInEuropeanUnion);
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        if (response.countryIsoCode == null) break;
                        data.put("country_iso_code", response.countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        if (response.countryName == null) break;
                        data.put("country_name", response.countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        if (response.continentCode == null) break;
                        data.put("continent_code", response.continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        if (response.continentName == null) break;
                        data.put("continent_name", response.continentName);
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.registeredCountryIsInEuropeanUnion == null) break;
                        data.put("registered_country_in_european_union", response.registeredCountryIsInEuropeanUnion);
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (response.registeredCountryIsoCode == null) break;
                        data.put("registered_country_iso_code", response.registeredCountryIsoCode);
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (response.registeredCountryName == null) break;
                        data.put("registered_country_name", response.registeredCountryName);
                    }
                }
            }
            return data;
        }
    }

    record CacheableCountryResponse(Boolean isInEuropeanUnion, String countryIsoCode, String countryName, String continentCode, String continentName, Boolean registeredCountryIsInEuropeanUnion, String registeredCountryIsoCode, String registeredCountryName) {
    }

    static class ConnectionType
    extends AbstractBase<ConnectionTypeResponse, ConnectionTypeResponse> {
        ConnectionType(Set<Database.Property> properties) {
            super(properties, ConnectionTypeResponse.class, (response, ipAddress, network, locales) -> new ConnectionTypeResponse(response, ipAddress, network));
        }

        @Override
        protected ConnectionTypeResponse cacheableRecord(ConnectionTypeResponse response) {
            return response;
        }

        @Override
        protected Map<String, Object> transform(ConnectionTypeResponse response) {
            ConnectionTypeResponse.ConnectionType connectionType = response.getConnectionType();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case CONNECTION_TYPE: {
                        if (connectionType == null) break;
                        data.put("connection_type", connectionType.toString());
                    }
                }
            }
            return data;
        }
    }

    static class City
    extends AbstractBase<CityResponse, IpDataLookup.Result<CacheableCityResponse>> {
        City(Set<Database.Property> properties) {
            super(properties, CityResponse.class, CityResponse::new);
        }

        @Override
        protected IpDataLookup.Result<CacheableCityResponse> cacheableRecord(CityResponse response) {
            com.maxmind.geoip2.record.Country country = response.getCountry();
            Continent continent = response.getContinent();
            Subdivision subdivision = response.getMostSpecificSubdivision();
            com.maxmind.geoip2.record.City city = response.getCity();
            Location location = response.getLocation();
            Postal postal = response.getPostal();
            com.maxmind.geoip2.record.Country registeredCountry = response.getRegisteredCountry();
            Traits traits = response.getTraits();
            return new IpDataLookup.Result<CacheableCityResponse>(new CacheableCityResponse(MaxmindIpDataLookups.isInEuropeanUnion(country), country.getIsoCode(), country.getName(), continent.getCode(), continent.getName(), MaxmindIpDataLookups.regionIsoCode(country, subdivision), subdivision.getName(), city.getName(), location.getTimeZone(), location.getLatitude(), location.getLongitude(), location.getAccuracyRadius(), postal.getCode(), MaxmindIpDataLookups.isInEuropeanUnion(registeredCountry), registeredCountry.getIsoCode(), registeredCountry.getName()), traits.getIpAddress(), traits.getNetwork().toString());
        }

        @Override
        protected Map<String, Object> transform(IpDataLookup.Result<CacheableCityResponse> result) {
            CacheableCityResponse response = result.result();
            HashMap<String, Object> data = new HashMap<String, Object>();
            block18: for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", result.ip());
                        break;
                    }
                    case COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.isInEuropeanUnion == null) break;
                        data.put("country_in_european_union", response.isInEuropeanUnion);
                        break;
                    }
                    case COUNTRY_ISO_CODE: {
                        if (response.countryIsoCode == null) break;
                        data.put("country_iso_code", response.countryIsoCode);
                        break;
                    }
                    case COUNTRY_NAME: {
                        if (response.countryName == null) break;
                        data.put("country_name", response.countryName);
                        break;
                    }
                    case CONTINENT_CODE: {
                        if (response.continentCode == null) break;
                        data.put("continent_code", response.continentCode);
                        break;
                    }
                    case CONTINENT_NAME: {
                        if (response.continentName == null) break;
                        data.put("continent_name", response.continentName);
                        break;
                    }
                    case REGION_ISO_CODE: {
                        if (response.regionIsoCode == null) break;
                        data.put("region_iso_code", response.regionIsoCode);
                        break;
                    }
                    case REGION_NAME: {
                        if (response.regionName == null) break;
                        data.put("region_name", response.regionName);
                        break;
                    }
                    case CITY_NAME: {
                        if (response.cityName == null) break;
                        data.put("city_name", response.cityName);
                        break;
                    }
                    case TIMEZONE: {
                        if (response.timezone == null) break;
                        data.put("timezone", response.timezone);
                        break;
                    }
                    case LOCATION: {
                        Double latitude = response.latitude;
                        Double longitude = response.longitude;
                        if (latitude == null || longitude == null) continue block18;
                        HashMap<String, Double> locationObject = new HashMap<String, Double>();
                        locationObject.put("lat", latitude);
                        locationObject.put("lon", longitude);
                        data.put("location", locationObject);
                        break;
                    }
                    case ACCURACY_RADIUS: {
                        if (response.accuracyRadius == null) break;
                        data.put("accuracy_radius", response.accuracyRadius);
                        break;
                    }
                    case POSTAL_CODE: {
                        if (response.postalCode == null) break;
                        data.put("postal_code", response.postalCode);
                        break;
                    }
                    case REGISTERED_COUNTRY_IN_EUROPEAN_UNION: {
                        if (response.registeredCountryIsInEuropeanUnion == null) break;
                        data.put("registered_country_in_european_union", response.registeredCountryIsInEuropeanUnion);
                        break;
                    }
                    case REGISTERED_COUNTRY_ISO_CODE: {
                        if (response.registeredCountryIsoCode == null) break;
                        data.put("registered_country_iso_code", response.registeredCountryIsoCode);
                        break;
                    }
                    case REGISTERED_COUNTRY_NAME: {
                        if (response.registeredCountryName == null) break;
                        data.put("registered_country_name", response.registeredCountryName);
                    }
                }
            }
            return data;
        }
    }

    record CacheableCityResponse(Boolean isInEuropeanUnion, String countryIsoCode, String countryName, String continentCode, String continentName, String regionIsoCode, String regionName, String cityName, String timezone, Double latitude, Double longitude, Integer accuracyRadius, String postalCode, Boolean registeredCountryIsInEuropeanUnion, String registeredCountryIsoCode, String registeredCountryName) {
    }

    static class Asn
    extends AbstractBase<AsnResponse, AsnResponse> {
        Asn(Set<Database.Property> properties) {
            super(properties, AsnResponse.class, (response, ipAddress, network, locales) -> new AsnResponse(response, ipAddress, network));
        }

        @Override
        protected AsnResponse cacheableRecord(AsnResponse response) {
            return response;
        }

        @Override
        protected Map<String, Object> transform(AsnResponse response) {
            Long asn = response.getAutonomousSystemNumber();
            String organizationName = response.getAutonomousSystemOrganization();
            Network network = response.getNetwork();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case ASN: {
                        if (asn == null) break;
                        data.put("asn", asn);
                        break;
                    }
                    case ORGANIZATION_NAME: {
                        if (organizationName == null) break;
                        data.put("organization_name", organizationName);
                        break;
                    }
                    case NETWORK: {
                        if (network == null) break;
                        data.put("network", network.toString());
                    }
                }
            }
            return data;
        }
    }

    static class AnonymousIp
    extends AbstractBase<AnonymousIpResponse, AnonymousIpResponse> {
        AnonymousIp(Set<Database.Property> properties) {
            super(properties, AnonymousIpResponse.class, (response, ipAddress, network, locales) -> new AnonymousIpResponse(response, ipAddress, network));
        }

        @Override
        protected AnonymousIpResponse cacheableRecord(AnonymousIpResponse response) {
            return response;
        }

        @Override
        protected Map<String, Object> transform(AnonymousIpResponse response) {
            boolean isHostingProvider = response.isHostingProvider();
            boolean isTorExitNode = response.isTorExitNode();
            boolean isAnonymousVpn = response.isAnonymousVpn();
            boolean isAnonymous = response.isAnonymous();
            boolean isPublicProxy = response.isPublicProxy();
            boolean isResidentialProxy = response.isResidentialProxy();
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Database.Property property : this.properties) {
                switch (property) {
                    case IP: {
                        data.put("ip", response.getIpAddress());
                        break;
                    }
                    case HOSTING_PROVIDER: {
                        data.put("hosting_provider", isHostingProvider);
                        break;
                    }
                    case TOR_EXIT_NODE: {
                        data.put("tor_exit_node", isTorExitNode);
                        break;
                    }
                    case ANONYMOUS_VPN: {
                        data.put("anonymous_vpn", isAnonymousVpn);
                        break;
                    }
                    case ANONYMOUS: {
                        data.put("anonymous", isAnonymous);
                        break;
                    }
                    case PUBLIC_PROXY: {
                        data.put("public_proxy", isPublicProxy);
                        break;
                    }
                    case RESIDENTIAL_PROXY: {
                        data.put("residential_proxy", isResidentialProxy);
                    }
                }
            }
            return data;
        }
    }
}

