/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.vectors.KnnVectorQueryBuilder;
import org.elasticsearch.search.vectors.RescoreVectorBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class KnnQuery
extends Query {
    private final String field;
    private final float[] query;
    private final Map<String, Object> options;
    public static final String RESCORE_OVERSAMPLE_FIELD = "rescore_oversample";

    public KnnQuery(Source source, String field, float[] query, Map<String, Object> options) {
        super(source);
        assert (options != null);
        this.field = field;
        this.query = query;
        this.options = options;
    }

    protected QueryBuilder asBuilder() {
        Integer k = (Integer)this.options.get(KnnVectorQueryBuilder.K_FIELD.getPreferredName());
        Integer numCands = (Integer)this.options.get(KnnVectorQueryBuilder.NUM_CANDS_FIELD.getPreferredName());
        RescoreVectorBuilder rescoreVectorBuilder = null;
        Float oversample = (Float)this.options.get(RESCORE_OVERSAMPLE_FIELD);
        if (oversample != null) {
            rescoreVectorBuilder = new RescoreVectorBuilder(oversample.floatValue());
        }
        Float vectorSimilarity = (Float)this.options.get(KnnVectorQueryBuilder.VECTOR_SIMILARITY_FIELD.getPreferredName());
        KnnVectorQueryBuilder queryBuilder = new KnnVectorQueryBuilder(this.field, this.query, k, numCands, rescoreVectorBuilder, vectorSimilarity);
        Number boost = (Number)this.options.get(AbstractQueryBuilder.BOOST_FIELD.getPreferredName());
        if (boost != null) {
            queryBuilder.boost(boost.floatValue());
        }
        return queryBuilder;
    }

    protected String innerToString() {
        return "knn(" + this.field + ", " + Arrays.toString(this.query) + " options={" + String.valueOf(this.options) + "}))";
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        KnnQuery knnQuery = (KnnQuery)((Object)o);
        return Objects.equals(this.field, knnQuery.field) && Objects.deepEquals(this.query, knnQuery.query) && Objects.equals(this.options, knnQuery.options);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, Arrays.hashCode(this.query), this.options);
    }

    public boolean scorable() {
        return true;
    }

    public boolean containsPlan() {
        return false;
    }
}

