/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;

class TypeConverter {
    private final String evaluatorName;
    private final EvalOperator.ExpressionEvaluator convertEvaluator;

    private TypeConverter(String evaluatorName, EvalOperator.ExpressionEvaluator convertEvaluator) {
        this.evaluatorName = evaluatorName;
        this.convertEvaluator = convertEvaluator;
    }

    public static TypeConverter fromConvertFunction(AbstractConvertFunction convertFunction) {
        DriverContext driverContext1 = new DriverContext(BigArrays.NON_RECYCLING_INSTANCE, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE));
        return new TypeConverter(convertFunction.functionName(), convertFunction.toEvaluator(new EvaluatorMapper.ToEvaluator(){

            @Override
            public EvalOperator.ExpressionEvaluator.Factory apply(Expression expression) {
                return driverContext -> new EvalOperator.ExpressionEvaluator(){

                    public Block eval(Page page) {
                        return page.getBlock(0);
                    }

                    public long baseRamBytesUsed() {
                        throw new UnsupportedOperationException("not used");
                    }

                    public void close() {
                    }
                };
            }

            @Override
            public FoldContext foldCtx() {
                throw new IllegalStateException("not folding");
            }
        }).get(driverContext1));
    }

    public Block convert(Block block) {
        return this.convertEvaluator.eval(new Page(new Block[]{block}));
    }

    public String toString() {
        return this.evaluatorName;
    }
}

