/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.session.Configuration;

public class PlanConcurrencyCalculator {
    public static final PlanConcurrencyCalculator INSTANCE = new PlanConcurrencyCalculator();

    private PlanConcurrencyCalculator() {
    }

    @Nullable
    public Integer calculateNodesConcurrency(PhysicalPlan dataNodePlan, Configuration configuration) {
        if (configuration.pragmas().maxConcurrentNodesPerCluster() > 0) {
            return configuration.pragmas().maxConcurrentNodesPerCluster();
        }
        if (dataNodePlan == null) {
            return null;
        }
        Integer dataNodeLimit = this.getDataNodeLimit(dataNodePlan);
        if (dataNodeLimit != null) {
            return this.limitToConcurrency(dataNodeLimit);
        }
        return null;
    }

    private Integer limitToConcurrency(int limit) {
        if (limit > 1000) {
            return null;
        }
        return Math.max(2, (int)(Math.log(limit) / Math.log(2.0)));
    }

    @Nullable
    private Integer getDataNodeLimit(PhysicalPlan dataNodePlan) {
        LogicalPlan logicalPlan = this.getFragmentPlan(dataNodePlan);
        Holder relationFound = new Holder((Object)false);
        Holder forbiddenNodeFound = new Holder((Object)false);
        Holder limitValue = new Holder(null);
        logicalPlan.forEachUp(node -> {
            if (limitValue.get() == null && !((Boolean)forbiddenNodeFound.get()).booleanValue()) {
                if (node instanceof EsRelation) {
                    relationFound.set((Object)true);
                } else if (((Boolean)relationFound.get()).booleanValue()) {
                    Limit limit;
                    Expression patt3281$temp;
                    if (node instanceof Limit && (patt3281$temp = (limit = (Limit)node).limit()) instanceof Literal) {
                        Literal literalLimit = (Literal)patt3281$temp;
                        limitValue.set((Object)((Integer)literalLimit.value()));
                    } else {
                        forbiddenNodeFound.set((Object)true);
                    }
                }
            }
        });
        return (Integer)limitValue.get();
    }

    private LogicalPlan getFragmentPlan(PhysicalPlan plan) {
        Holder foundPlan = new Holder();
        plan.forEachDown(node -> {
            if (node instanceof FragmentExec) {
                FragmentExec fragment = (FragmentExec)node;
                foundPlan.set((Object)fragment.fragment());
            }
        });
        return (LogicalPlan)((Object)foundPlan.get());
    }
}

