/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public abstract class UnaryExec
extends PhysicalPlan {
    private final PhysicalPlan child;
    private AttributeSet lazyOutputSet;

    protected UnaryExec(Source source, PhysicalPlan child) {
        super(source, Collections.singletonList(child));
        this.child = child;
    }

    public final PhysicalPlan replaceChildren(List<PhysicalPlan> newChildren) {
        return this.replaceChild(newChildren.get(0));
    }

    public abstract UnaryExec replaceChild(PhysicalPlan var1);

    public PhysicalPlan child() {
        return this.child;
    }

    @Override
    public List<Attribute> output() {
        return this.child.output();
    }

    @Override
    public AttributeSet outputSet() {
        if (this.lazyOutputSet == null) {
            List<Attribute> output = this.output();
            this.lazyOutputSet = output == this.child.output() ? this.child.outputSet() : AttributeSet.of(output);
            return this.lazyOutputSet;
        }
        return this.lazyOutputSet;
    }

    @Override
    public AttributeSet inputSet() {
        return this.child.outputSet();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object)this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnaryExec other = (UnaryExec)((Object)obj);
        return Objects.equals((Object)this.child, (Object)other.child);
    }
}

