/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Build;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.ParserUtils;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.ChangePoint;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.Sample;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.inference.Rerank;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.joni.exception.SyntaxException;

public class LogicalPlanBuilder
extends ExpressionBuilder {
    public static final int MAX_QUERY_DEPTH = 500;
    private int queryDepth = 0;

    public LogicalPlanBuilder(ExpressionBuilder.ParsingContext context) {
        super(context);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        LogicalPlan p = ParserUtils.typedParsing(this, ctx, LogicalPlan.class);
        Iterator<ParsingException> errors = this.context.params().parsingErrors();
        if (!errors.hasNext()) {
            return p;
        }
        throw ParsingException.combineParsingExceptions(errors);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList(this, ctxs, LogicalPlan.class);
    }

    @Override
    public LogicalPlan visitSingleStatement(EsqlBaseParser.SingleStatementContext ctx) {
        LogicalPlan plan = this.plan((ParseTree)ctx.query());
        this.telemetryAccounting(plan);
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicalPlan visitCompositeQuery(EsqlBaseParser.CompositeQueryContext ctx) {
        ++this.queryDepth;
        if (this.queryDepth > 500) {
            throw new ParsingException("ESQL statement exceeded the maximum query depth allowed ({}): [{}]", 500, ctx.getText());
        }
        try {
            LogicalPlan input = this.plan((ParseTree)ctx.query());
            this.telemetryAccounting(input);
            PlanFactory makePlan = ParserUtils.typedParsing(this, (ParseTree)ctx.processingCommand(), PlanFactory.class);
            LogicalPlan logicalPlan = (LogicalPlan)((Object)makePlan.apply(input));
            return logicalPlan;
        }
        finally {
            --this.queryDepth;
        }
    }

    private LogicalPlan telemetryAccounting(LogicalPlan node) {
        if (node instanceof TelemetryAware) {
            TelemetryAware ma = (TelemetryAware)((Object)node);
            this.context.telemetry().command(ma);
        }
        return node;
    }

    @Override
    public PlanFactory visitEvalCommand(EsqlBaseParser.EvalCommandContext ctx) {
        return p -> new Eval(ParserUtils.source(ctx), (LogicalPlan)((Object)p), (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public PlanFactory visitGrokCommand(EsqlBaseParser.GrokCommandContext ctx) {
        return p -> {
            Grok.Parser grokParser;
            Source source = ParserUtils.source(ctx);
            String pattern = BytesRefs.toString((Object)this.visitString(ctx.string()).fold(FoldContext.small()));
            try {
                grokParser = Grok.pattern(source, pattern);
            }
            catch (SyntaxException e) {
                throw new ParsingException(source, "Invalid grok pattern [{}]: [{}]", pattern, e.getMessage());
            }
            this.validateGrokPattern(source, grokParser, pattern);
            Grok result = new Grok(ParserUtils.source(ctx), (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), grokParser);
            return result;
        };
    }

    private void validateGrokPattern(Source source, Grok.Parser grokParser, String pattern) {
        HashMap<String, DataType> definedAttributes = new HashMap<String, DataType>();
        for (Attribute field : grokParser.extractedFields()) {
            DataType type;
            String name = field.name();
            DataType prev = definedAttributes.put(name, type = field.dataType());
            if (prev == null) continue;
            throw new ParsingException(source, "Invalid GROK pattern [" + pattern + "]: the attribute [" + name + "] is defined multiple times with different types", new Object[0]);
        }
    }

    @Override
    public PlanFactory visitDissectCommand(EsqlBaseParser.DissectCommandContext ctx) {
        return p -> {
            String pattern = BytesRefs.toString((Object)this.visitString(ctx.string()).fold(FoldContext.small()));
            Object options = this.visitCommandOptions(ctx.commandOptions());
            String appendSeparator = "";
            for (Map.Entry item : options.entrySet()) {
                if (!((String)item.getKey()).equalsIgnoreCase("append_separator")) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid option for dissect: [{}]", item.getKey());
                }
                if (!(item.getValue() instanceof BytesRef)) {
                    throw new ParsingException(ParserUtils.source(ctx), "Invalid value for dissect append_separator: expected a string, but was [{}]", item.getValue());
                }
                appendSeparator = BytesRefs.toString(item.getValue());
            }
            Source src = ParserUtils.source(ctx);
            try {
                DissectParser parser = new DissectParser(pattern, appendSeparator);
                Set referenceKeys = parser.referenceKeys();
                if (!referenceKeys.isEmpty()) {
                    throw new ParsingException(src, "Reference keys not supported in dissect patterns: [%{*{}}]", referenceKeys.iterator().next());
                }
                Dissect.Parser esqlDissectParser = new Dissect.Parser(pattern, appendSeparator, parser);
                List<Attribute> keys = esqlDissectParser.keyAttributes(src);
                return new Dissect(src, (LogicalPlan)((Object)p), this.expression((ParseTree)ctx.primaryExpression()), esqlDissectParser, keys);
            }
            catch (DissectException e) {
                throw new ParsingException(src, "Invalid pattern for dissect: [{}]", pattern);
            }
        };
    }

    @Override
    public PlanFactory visitMvExpandCommand(EsqlBaseParser.MvExpandCommandContext ctx) {
        UnresolvedAttribute field = this.visitQualifiedName(ctx.qualifiedName());
        Source src = ParserUtils.source(ctx);
        return child -> new MvExpand(src, (LogicalPlan)((Object)child), (NamedExpression)field, (Attribute)new UnresolvedAttribute(src, field.name()));
    }

    @Override
    public Map<String, Object> visitCommandOptions(EsqlBaseParser.CommandOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsqlBaseParser.CommandOptionContext option : ctx.commandOption()) {
            result.put(this.visitIdentifier(option.identifier()), this.expression((ParseTree)option.constant()).fold(FoldContext.small()));
        }
        return result;
    }

    @Override
    public LogicalPlan visitRowCommand(EsqlBaseParser.RowCommandContext ctx) {
        return new Row(ParserUtils.source(ctx), (List<Alias>)NamedExpressions.mergeOutputExpressions((List<? extends NamedExpression>)this.visitFields(ctx.fields()), List.of()));
    }

    @Override
    public LogicalPlan visitFromCommand(EsqlBaseParser.FromCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        IndexPattern table = new IndexPattern(source, this.visitIndexPattern((List)ctx.indexPattern()));
        LinkedHashMap<String, MetadataAttribute> metadataMap = new LinkedHashMap<String, MetadataAttribute>();
        if (ctx.metadata() != null) {
            EsqlBaseParser.Deprecated_metadataContext deprecatedContext = ctx.metadata().deprecated_metadata();
            EsqlBaseParser.MetadataOptionContext metadataOptionContext = null;
            if (deprecatedContext != null) {
                Location s = ParserUtils.source(deprecatedContext).source();
                HeaderWarning.addWarning((String)"Line {}:{}: Square brackets '[]' need to be removed in FROM METADATA declaration", (Object[])new Object[]{s.getLineNumber(), s.getColumnNumber()});
                metadataOptionContext = deprecatedContext.metadataOption();
            } else {
                metadataOptionContext = ctx.metadata().metadataOption();
            }
            for (TerminalNode c : metadataOptionContext.UNQUOTED_SOURCE()) {
                String id = c.getText();
                Source src = ParserUtils.source(c);
                if (!MetadataAttribute.isSupported((String)id)) {
                    throw new ParsingException(src, "unsupported metadata field [" + id + "]", new Object[0]);
                }
                Attribute a = (Attribute)metadataMap.put(id, MetadataAttribute.create((Source)src, (String)id));
                if (a == null) continue;
                throw new ParsingException(src, "metadata field [" + id + "] already declared [" + String.valueOf(a.source().source()) + "]", new Object[0]);
            }
        }
        return new UnresolvedRelation(source, table, false, List.of((Attribute[])metadataMap.values().toArray(Attribute[]::new)), IndexMode.STANDARD, null, "FROM");
    }

    @Override
    public PlanFactory visitStatsCommand(EsqlBaseParser.StatsCommandContext ctx) {
        Stats stats = this.stats(ParserUtils.source(ctx), ctx.grouping, ctx.stats);
        return input -> new Aggregate(ParserUtils.source(ctx), (LogicalPlan)((Object)input), Aggregate.AggregateType.STANDARD, stats.groupings, stats.aggregates);
    }

    private Stats stats(Source source, EsqlBaseParser.FieldsContext groupingsCtx, EsqlBaseParser.AggFieldsContext aggregatesCtx) {
        List<NamedExpression> groupings = this.visitGrouping(groupingsCtx);
        ArrayList<Attribute> aggregates = new ArrayList<Attribute>((Collection<Attribute>)this.visitAggFields(aggregatesCtx));
        if (aggregates.isEmpty() && groupings.isEmpty()) {
            throw new ParsingException(source, "At least one aggregation or grouping expression required in [{}]", source.text());
        }
        if (!groupings.isEmpty() && !aggregates.isEmpty()) {
            LinkedHashSet groupNames = new LinkedHashSet(Expressions.names(groupings));
            LinkedHashSet linkedHashSet = new LinkedHashSet(Expressions.names((Collection)Expressions.references(groupings)));
            for (NamedExpression namedExpression : aggregates) {
                Expression e = Alias.unwrap((Expression)namedExpression);
                if (e.resolved() || e instanceof UnresolvedFunction) continue;
                String name = e.sourceText();
                if (groupNames.contains(name)) {
                    this.fail(e, "grouping key [{}] already specified in the STATS BY clause", name);
                    continue;
                }
                if (!linkedHashSet.contains(name)) continue;
                this.fail(e, "Cannot specify grouping expression [{}] as an aggregate", name);
            }
        }
        for (Expression expression : groupings) {
            aggregates.add(Expressions.attribute((Expression)expression));
        }
        return new Stats(new ArrayList<NamedExpression>(groupings), aggregates);
    }

    private void fail(Expression exp, String message, Object ... args) {
        throw new VerificationException(Collections.singletonList(Failure.fail(exp, message, args)));
    }

    @Override
    public PlanFactory visitInlinestatsCommand(EsqlBaseParser.InlinestatsCommandContext ctx) {
        if (!EsqlPlugin.INLINESTATS_FEATURE_FLAG.isEnabled()) {
            throw new ParsingException(ParserUtils.source(ctx), "INLINESTATS command currently requires a snapshot build", new Object[0]);
        }
        Object aggFields = this.visitAggFields(ctx.stats);
        ArrayList<NamedExpression> aggregates = new ArrayList<NamedExpression>((Collection<NamedExpression>)aggFields);
        List<NamedExpression> groupings = this.visitGrouping(ctx.grouping);
        aggregates.addAll(groupings);
        return input -> new InlineStats(ParserUtils.source(ctx), new Aggregate(ParserUtils.source(ctx), (LogicalPlan)((Object)input), Aggregate.AggregateType.STANDARD, (List<Expression>)new ArrayList<Expression>(groupings), (List<? extends NamedExpression>)aggregates));
    }

    @Override
    public PlanFactory visitWhereCommand(EsqlBaseParser.WhereCommandContext ctx) {
        Expression expression = this.expression((ParseTree)ctx.booleanExpression());
        return input -> new Filter(ParserUtils.source(ctx), (LogicalPlan)((Object)input), expression);
    }

    @Override
    public PlanFactory visitLimitCommand(EsqlBaseParser.LimitCommandContext ctx) {
        Integer i;
        Source source = ParserUtils.source(ctx);
        Object val = this.expression((ParseTree)ctx.constant()).fold(FoldContext.small());
        if (val instanceof Integer && (i = (Integer)val) >= 0) {
            return input -> new Limit(source, (Expression)new Literal(source, (Object)i, DataType.INTEGER), (LogicalPlan)((Object)input));
        }
        String valueType = this.expression((ParseTree)ctx.constant()).dataType().typeName();
        throw new ParsingException(source, "value of [" + source.text() + "] must be a non negative integer, found value [" + ctx.constant().getText() + "] type [" + valueType + "]", new Object[0]);
    }

    @Override
    public PlanFactory visitSortCommand(EsqlBaseParser.SortCommandContext ctx) {
        List<Order> orders = ParserUtils.visitList(this, ctx.orderExpression(), Order.class);
        Source source = ParserUtils.source(ctx);
        return input -> new OrderBy(source, (LogicalPlan)((Object)input), orders);
    }

    @Override
    public Explain visitExplainCommand(EsqlBaseParser.ExplainCommandContext ctx) {
        return new Explain(ParserUtils.source(ctx), this.plan((ParseTree)ctx.subqueryExpression().query()));
    }

    @Override
    public PlanFactory visitDropCommand(EsqlBaseParser.DropCommandContext ctx) {
        List<NamedExpression> removals = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Removing all fields is not allowed [{}]", src.text());
            }
        });
        return child -> new Drop(ParserUtils.source(ctx), (LogicalPlan)((Object)child), removals);
    }

    @Override
    public PlanFactory visitRenameCommand(EsqlBaseParser.RenameCommandContext ctx) {
        List<Alias> renamings = ctx.renameClause().stream().map(this::visitRenameClause).toList();
        return child -> new Rename(ParserUtils.source(ctx), (LogicalPlan)((Object)child), renamings);
    }

    @Override
    public PlanFactory visitKeepCommand(EsqlBaseParser.KeepCommandContext ctx) {
        Holder hasSeenStar = new Holder((Object)false);
        List<NamedExpression> projections = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedStar) {
                if (((Boolean)hasSeenStar.get()).booleanValue()) {
                    Source src = ne.source();
                    throw new ParsingException(src, "Cannot specify [*] more than once", src.text());
                }
                hasSeenStar.set((Object)Boolean.TRUE);
            }
        });
        return child -> new Keep(ParserUtils.source(ctx), (LogicalPlan)((Object)child), (List<? extends NamedExpression>)projections);
    }

    @Override
    public LogicalPlan visitShowInfo(EsqlBaseParser.ShowInfoContext ctx) {
        return new ShowInfo(ParserUtils.source(ctx));
    }

    @Override
    public PlanFactory visitEnrichCommand(EsqlBaseParser.EnrichCommandContext ctx) {
        return p -> {
            String patternString;
            EmptyAttribute matchField;
            Source source = ParserUtils.source(ctx);
            Tuple<Enrich.Mode, String> tuple = LogicalPlanBuilder.parsePolicyName(ctx.policyName);
            Enrich.Mode mode = (Enrich.Mode)((Object)((Object)tuple.v1()));
            String policyNameString = (String)tuple.v2();
            Object object = matchField = ctx.ON() != null ? this.visitQualifiedNamePattern(ctx.matchField) : new EmptyAttribute(source);
            if (matchField instanceof UnresolvedNamePattern) {
                UnresolvedNamePattern up = (UnresolvedNamePattern)matchField;
                v1 = up.pattern();
            } else {
                v1 = patternString = matchField instanceof UnresolvedStar ? "*" : null;
            }
            if (patternString != null) {
                throw new ParsingException(source, "Using wildcards [*] in ENRICH WITH projections is not allowed, found [{}]", patternString);
            }
            List<NamedExpression> keepClauses = ParserUtils.visitList(this, ctx.enrichWithClause(), NamedExpression.class);
            return new Enrich(source, (LogicalPlan)((Object)p), mode, (Expression)Literal.keyword((Source)ParserUtils.source(ctx.policyName), (String)policyNameString), (NamedExpression)matchField, null, Map.of(), (List<NamedExpression>)(keepClauses.isEmpty() ? List.of() : keepClauses));
        };
    }

    @Override
    public PlanFactory visitChangePointCommand(EsqlBaseParser.ChangePointCommandContext ctx) {
        Source src = ParserUtils.source(ctx);
        UnresolvedAttribute value = this.visitQualifiedName(ctx.value);
        UnresolvedAttribute key = ctx.key == null ? new UnresolvedAttribute(src, "@timestamp") : this.visitQualifiedName(ctx.key);
        ReferenceAttribute targetType = new ReferenceAttribute(src, ctx.targetType == null ? "type" : this.visitQualifiedName(ctx.targetType).name(), DataType.KEYWORD);
        ReferenceAttribute targetPvalue = new ReferenceAttribute(src, ctx.targetPvalue == null ? "pvalue" : this.visitQualifiedName(ctx.targetPvalue).name(), DataType.DOUBLE);
        return arg_0 -> LogicalPlanBuilder.lambda$visitChangePointCommand$16(src, (Attribute)value, (Attribute)key, (Attribute)targetType, (Attribute)targetPvalue, arg_0);
    }

    private static Tuple<Enrich.Mode, String> parsePolicyName(EsqlBaseParser.EnrichPolicyNameContext ctx) {
        String stringValue;
        if (ctx.ENRICH_POLICY_NAME() != null) {
            stringValue = ctx.ENRICH_POLICY_NAME().getText();
        } else {
            stringValue = ctx.QUOTED_STRING().getText();
            stringValue = stringValue.substring(1, stringValue.length() - 1);
        }
        int index = stringValue.indexOf(":");
        Enrich.Mode mode = null;
        if (index >= 0) {
            String modeValue = stringValue.substring(0, index);
            if (modeValue.startsWith("_")) {
                mode = Enrich.Mode.from(modeValue.substring(1));
            }
            if (mode == null) {
                throw new ParsingException(ParserUtils.source(ctx), "Unrecognized value [{}], ENRICH policy qualifier needs to be one of {}", modeValue, Arrays.stream(Enrich.Mode.values()).map(s -> "_" + String.valueOf(s)).toList());
            }
        } else {
            mode = Enrich.Mode.ANY;
        }
        String policyName = index < 0 ? stringValue : stringValue.substring(index + 1);
        return new Tuple((Object)mode, (Object)policyName);
    }

    @Override
    public LogicalPlan visitMetricsCommand(EsqlBaseParser.MetricsCommandContext ctx) {
        if (!Build.current().isSnapshot()) {
            throw new IllegalArgumentException("METRICS command currently requires a snapshot build");
        }
        Source source = ParserUtils.source(ctx);
        IndexPattern table = new IndexPattern(source, this.visitIndexPattern((List)ctx.indexPattern()));
        if (ctx.aggregates == null && ctx.grouping == null) {
            return new UnresolvedRelation(source, table, false, List.of(), IndexMode.STANDARD, null, "METRICS");
        }
        Stats stats = this.stats(source, ctx.grouping, ctx.aggregates);
        UnresolvedRelation relation = new UnresolvedRelation(source, table, false, List.of(new MetadataAttribute(source, "_tsid", DataType.KEYWORD, false)), IndexMode.TIME_SERIES, null);
        return new Aggregate(source, relation, Aggregate.AggregateType.METRICS, stats.groupings, stats.aggregates);
    }

    @Override
    public PlanFactory visitLookupCommand(EsqlBaseParser.LookupCommandContext ctx) {
        if (!Build.current().isSnapshot()) {
            throw new ParsingException(ParserUtils.source(ctx), "LOOKUP__ is in preview and only available in SNAPSHOT build", new Object[0]);
        }
        Source source = ParserUtils.source(ctx);
        List<NamedExpression> matchFields = this.visitQualifiedNamePatterns(ctx.qualifiedNamePatterns(), ne -> {
            if (ne instanceof UnresolvedNamePattern || ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Using wildcards [*] in LOOKUP ON is not allowed yet [{}]", src.text());
            }
            if (!(ne instanceof UnresolvedAttribute)) {
                throw new IllegalStateException("visitQualifiedNamePatterns can only return UnresolvedNamePattern, UnresolvedStar or UnresolvedAttribute");
            }
        });
        Literal tableName = Literal.keyword((Source)source, (String)this.visitIndexPattern((List)List.of(ctx.indexPattern())));
        return p -> new Lookup(source, (LogicalPlan)((Object)p), (Expression)tableName, (List<Attribute>)matchFields, null);
    }

    @Override
    public PlanFactory visitJoinCommand(EsqlBaseParser.JoinCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        if (!EsqlCapabilities.Cap.JOIN_LOOKUP_V12.isEnabled()) {
            throw new ParsingException(source, "JOIN is in preview and only available in SNAPSHOT build", new Object[0]);
        }
        if (ctx.type != null && ctx.type.getType() != 19) {
            String joinType = ctx.type == null ? "(INNER)" : ctx.type.getText();
            throw new ParsingException(source, "only LOOKUP JOIN available, {} JOIN unsupported at the moment", joinType);
        }
        EsqlBaseParser.JoinTargetContext target = ctx.joinTarget();
        String rightPattern = this.visitIndexPattern((List)List.of(target.index));
        if (rightPattern.contains("*")) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], * is not allowed in LOOKUP JOIN", rightPattern);
        }
        if (RemoteClusterAware.isRemoteIndexName((String)rightPattern)) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], remote clusters are not supported in LOOKUP JOIN", rightPattern);
        }
        if (rightPattern.contains("::")) {
            throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], index pattern selectors are not supported in LOOKUP JOIN", rightPattern);
        }
        UnresolvedRelation right = new UnresolvedRelation(ParserUtils.source(target), new IndexPattern(ParserUtils.source(target.index), rightPattern), false, Collections.emptyList(), IndexMode.LOOKUP, null);
        EsqlBaseParser.JoinConditionContext condition = ctx.joinCondition();
        List<Expression> predicates = this.expressions(condition.joinPredicate());
        ArrayList<UnresolvedAttribute> joinFields = new ArrayList<UnresolvedAttribute>(predicates.size());
        for (Expression f : predicates) {
            if (f instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)f;
                joinFields.add(ua);
                continue;
            }
            throw new ParsingException(f.source(), "JOIN ON clause only supports fields at the moment, found [{}]", f.sourceText());
        }
        int matchFieldsCount = joinFields.size();
        if (matchFieldsCount > 1) {
            throw new ParsingException(source, "JOIN ON clause only supports one field at the moment, found [{}]", matchFieldsCount);
        }
        return p -> {
            p.forEachUp(UnresolvedRelation.class, r -> {
                for (String leftPattern : Strings.splitStringByCommaToArray((String)r.indexPattern().indexPattern())) {
                    if (!RemoteClusterAware.isRemoteIndexName((String)leftPattern)) continue;
                    throw new ParsingException(ParserUtils.source(target), "invalid index pattern [{}], remote clusters are not supported in LOOKUP JOIN", r.indexPattern().indexPattern());
                }
            });
            return new LookupJoin(source, (LogicalPlan)((Object)p), (LogicalPlan)right, (List<Attribute>)joinFields);
        };
    }

    private void checkForRemoteClusters(LogicalPlan plan, Source source, String commandName) {
        plan.forEachUp(UnresolvedRelation.class, r -> {
            for (String indexPattern : Strings.splitStringByCommaToArray((String)r.indexPattern().indexPattern())) {
                if (!RemoteClusterAware.isRemoteIndexName((String)indexPattern)) continue;
                throw new ParsingException(source, "invalid index pattern [{}], remote clusters are not supported with {}", r.indexPattern().indexPattern(), commandName);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PlanFactory visitRerankCommand(EsqlBaseParser.RerankCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        Object rerankFields = this.visitRerankFields(ctx.rerankFields());
        Expression queryText = this.expression((ParseTree)ctx.queryText);
        if (!(queryText instanceof Literal)) throw new ParsingException(ParserUtils.source(ctx.queryText), "RERANK only support string as query text but [{}] cannot be used as string", ctx.queryText.getText());
        Literal queryTextLiteral = (Literal)queryText;
        if (!DataType.isString((DataType)queryText.dataType())) throw new ParsingException(ParserUtils.source(ctx.queryText), "RERANK only support string as query text but [{}] cannot be used as string", ctx.queryText.getText());
        if (queryTextLiteral.value() != null) return arg_0 -> this.lambda$visitRerankCommand$23(source, queryText, (List)rerankFields, ctx, arg_0);
        throw new ParsingException(ParserUtils.source(ctx.queryText), "Query text cannot be null or undefined in RERANK", ctx.queryText.getText());
    }

    private Rerank visitRerankOptions(Rerank rerank, EsqlBaseParser.InferenceCommandOptionsContext ctx) {
        if (ctx == null) {
            return rerank;
        }
        Rerank.Builder rerankBuilder = new Rerank.Builder(rerank);
        for (EsqlBaseParser.InferenceCommandOptionContext option : ctx.inferenceCommandOption()) {
            String optionName = this.visitIdentifier(option.identifier());
            EsqlBaseParser.InferenceCommandOptionValueContext optionValue = option.inferenceCommandOptionValue();
            if (optionName.equals("inferenceId")) {
                rerankBuilder.withInferenceId((Expression)this.visitInferenceId(optionValue));
                continue;
            }
            if (optionName.equals("scoreColumn")) {
                rerankBuilder.withScoreAttribute((Attribute)this.visitRerankScoreAttribute(optionName, optionValue));
                continue;
            }
            throw new ParsingException(ParserUtils.source(option.identifier()), "Unknowm parameter [{}] in RERANK command", option.identifier().getText());
        }
        return rerankBuilder.build();
    }

    private UnresolvedAttribute visitRerankScoreAttribute(String optionName, EsqlBaseParser.InferenceCommandOptionValueContext ctx) {
        Expression optionValue;
        if (ctx.constant() == null && ctx.identifier() == null) {
            throw new ParsingException(ParserUtils.source(ctx), "Parameter [{}] is null or undefined", optionName);
        }
        Object object = optionValue = ctx.identifier() != null ? Literal.keyword((Source)ParserUtils.source(ctx.identifier()), (String)this.visitIdentifier(ctx.identifier())) : this.expression((ParseTree)ctx.constant());
        if (optionValue instanceof UnresolvedAttribute) {
            UnresolvedAttribute scoreAttribute = (UnresolvedAttribute)optionValue;
            return scoreAttribute;
        }
        if (optionValue instanceof Literal) {
            Literal literal = (Literal)optionValue;
            if (literal.value() == null) {
                throw new ParsingException(optionValue.source(), "Parameter [{}] is null or undefined", optionName);
            }
            Object object2 = literal.value();
            if (object2 instanceof BytesRef) {
                BytesRef attributeName = (BytesRef)object2;
                return new UnresolvedAttribute(literal.source(), BytesRefs.toString((Object)attributeName));
            }
        }
        throw new ParsingException(ParserUtils.source(ctx), "Option [{}] expects a valid attribute in RERANK command. [{}] provided.", optionName, ctx.constant().getText());
    }

    @Override
    public PlanFactory visitCompletionCommand(EsqlBaseParser.CompletionCommandContext ctx) {
        Source source = ParserUtils.source(ctx);
        Expression prompt = this.expression((ParseTree)ctx.prompt);
        Literal inferenceId = this.visitInferenceId(ctx.inferenceId);
        UnresolvedAttribute targetField = ctx.targetField == null ? new UnresolvedAttribute(source, "completion") : this.visitQualifiedName(ctx.targetField);
        return arg_0 -> LogicalPlanBuilder.lambda$visitCompletionCommand$24(source, inferenceId, prompt, (Attribute)targetField, arg_0);
    }

    private Literal visitInferenceId(EsqlBaseParser.IdentifierOrParameterContext ctx) {
        if (ctx.identifier() != null) {
            return Literal.keyword((Source)ParserUtils.source(ctx), (String)this.visitIdentifier(ctx.identifier()));
        }
        return this.visitInferenceId(this.expression((ParseTree)ctx.parameter()));
    }

    private Literal visitInferenceId(EsqlBaseParser.InferenceCommandOptionValueContext ctx) {
        if (ctx.identifier() != null) {
            return Literal.keyword((Source)ParserUtils.source(ctx), (String)this.visitIdentifier(ctx.identifier()));
        }
        return this.visitInferenceId(this.expression((ParseTree)ctx.constant()));
    }

    private Literal visitInferenceId(Expression expression) {
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (literal.value() == null) {
                throw new ParsingException(expression.source(), "Parameter [{}] is null or undefined and cannot be used as inference id", expression.source().text());
            }
            return literal;
        }
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute attribute = (UnresolvedAttribute)expression;
            return Literal.keyword((Source)expression.source(), (String)attribute.name());
        }
        throw new ParsingException(expression.source(), "Query parameter [{}] is not a string and cannot be used as inference id [{}]", expression.source().text(), expression.getClass());
    }

    @Override
    public PlanFactory visitSampleCommand(EsqlBaseParser.SampleCommandContext ctx) {
        Double probability;
        Source source = ParserUtils.source(ctx);
        Object val = this.expression((ParseTree)ctx.probability).fold(FoldContext.small());
        if (val instanceof Double && (probability = (Double)val) > 0.0 && probability < 1.0) {
            return input -> new Sample(source, (Expression)new Literal(source, (Object)probability, DataType.DOUBLE), (LogicalPlan)((Object)input));
        }
        throw new ParsingException(ParserUtils.source(ctx), "invalid value for SAMPLE probability [" + BytesRefs.toString((Object)val) + "], expecting a number between 0 and 1, exclusive", new Object[0]);
    }

    private static /* synthetic */ LogicalPlan lambda$visitCompletionCommand$24(Source source, Literal inferenceId, Expression prompt, Attribute targetField, LogicalPlan p) {
        return new Completion(source, p, (Expression)inferenceId, prompt, targetField);
    }

    private /* synthetic */ LogicalPlan lambda$visitRerankCommand$23(Source source, Expression queryText, List rerankFields, EsqlBaseParser.RerankCommandContext ctx, LogicalPlan p) {
        this.checkForRemoteClusters(p, source, "RERANK");
        return this.visitRerankOptions(new Rerank(source, p, queryText, rerankFields), ctx.inferenceCommandOptions());
    }

    private static /* synthetic */ LogicalPlan lambda$visitChangePointCommand$16(Source src, Attribute value, Attribute key, Attribute targetType, Attribute targetPvalue, LogicalPlan child) {
        return new ChangePoint(src, child, value, key, targetType, targetPvalue);
    }

    static interface PlanFactory
    extends Function<LogicalPlan, LogicalPlan> {
    }

    private record Stats(List<Expression> groupings, List<? extends NamedExpression> aggregates) {
    }
}

