/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ChangeCase;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.session.Configuration;

public class ToLower
extends ChangeCase {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToLower", ToLower::new);

    @FunctionInfo(returnType={"keyword"}, description="Returns a new string representing the input string converted to lower case.", examples={@Example(file="string", tag="to_lower"), @Example(file="string", tag="to_lower_mv")})
    public ToLower(Source source, @Param(name="str", type={"keyword", "text"}, description="String expression. If `null`, the function returns `null`.\nThe input can be a single- or multi-valued column or an expression.") Expression field, Configuration configuration) {
        super(source, field, configuration, ChangeCase.Case.LOWER);
    }

    private ToLower(StreamInput in) throws IOException {
        this(Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), ((PlanStreamInput)in).configuration());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.field());
    }

    public String getWriteableName() {
        return ToLower.ENTRY.name;
    }

    public ToLower replaceChild(Expression child) {
        return new ToLower(this.source(), child, this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToLower::new, (Object)this.field(), (Object)this.configuration());
    }
}

