/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Repeat;

public final class RepeatEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RepeatEvaluator.class);
    private final Source source;
    private final BreakingBytesRefBuilder scratch;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator number;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RepeatEvaluator(Source source, BreakingBytesRefBuilder scratch, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator number, DriverContext driverContext) {
        this.source = source;
        this.scratch = scratch;
        this.str = str;
        this.number = number;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                IntVector numberVector;
                BytesRefVector strVector;
                IntBlock numberBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                numberBlock = (IntBlock)this.number.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, numberBlock);
                                    if (numberBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (numberBlock != null) {
                                        try {
                                            numberBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                numberBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        numberVector = numberBlock.asVector();
                        if (numberVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, numberBlock);
                        if (numberBlock == null) break block19;
                        numberBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, numberVector);
                if (numberBlock == null) break block20;
                numberBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        return baseRamBytesUsed += this.number.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, IntBlock numberBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (numberBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (numberBlock.getValueCount(p) != 1) {
                    if (numberBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBytesRef(Repeat.process(this.scratch, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), numberBlock.getInt(numberBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, IntVector numberVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBytesRef(Repeat.process(this.scratch, strVector.getBytesRef(p, strScratch), numberVector.getInt(p)));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "RepeatEvaluator[str=" + String.valueOf(this.str) + ", number=" + String.valueOf(this.number) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, this.str, this.number});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory number;

        public Factory(Source source, Function<DriverContext, BreakingBytesRefBuilder> scratch, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory number) {
            this.source = source;
            this.scratch = scratch;
            this.str = str;
            this.number = number;
        }

        public RepeatEvaluator get(DriverContext context) {
            return new RepeatEvaluator(this.source, this.scratch.apply(context), this.str.get(context), this.number.get(context), context);
        }

        public String toString() {
            return "RepeatEvaluator[str=" + String.valueOf(this.str) + ", number=" + String.valueOf(this.number) + "]";
        }
    }
}

