/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Hash;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.HashConstantEvaluator;

public abstract class AbstractHashFunction
extends UnaryScalarFunction {
    protected AbstractHashFunction(Source source, Expression field) {
        super(source, field);
    }

    protected AbstractHashFunction(StreamInput in) throws IOException {
        super(in);
    }

    protected abstract Hash.HashFunction getHashFunction();

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new HashConstantEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "hash"), new Function<DriverContext, Hash.HashFunction>(){

            @Override
            public Hash.HashFunction apply(DriverContext context) {
                return AbstractHashFunction.this.getHashFunction().copy();
            }

            public String toString() {
                return AbstractHashFunction.this.getHashFunction().toString();
            }
        }, toEvaluator.apply(this.field));
    }
}

