/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotileToStringFromLongEvaluator;

public class StGeotileToString
extends AbstractConvertFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeotileToString", StGeotileToString::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.KEYWORD, (source, fieldEval) -> fieldEval), Map.entry(DataType.LONG, StGeotileToStringFromLongEvaluator.Factory::new));

    @FunctionInfo(returnType={"keyword"}, description="Converts an input value representing a geotile grid-ID in long format into a string.", examples={@Example(file="spatial-grid", tag="geotile_to_string")})
    public StGeotileToString(Source source, @Param(name="grid_id", type={"keyword", "long"}, description="Input geotile grid-id. The input can be a single- or multi-valued column or an expression.") Expression v) {
        super(source, v);
    }

    private StGeotileToString(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StGeotileToString.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StGeotileToString(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeotileToString::new, (Object)this.field());
    }

    static BytesRef fromLong(long gridId) {
        return new BytesRef((CharSequence)GeoTileUtils.stringEncode((long)gridId));
    }
}

