/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;

public final class RoundIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(RoundIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator decimals;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundIntEvaluator(Source source, EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator decimals, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.decimals = decimals;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock valBlock = (IntBlock)this.val.eval(page);){
            IntBlock intBlock;
            block20: {
                LongVector decimalsVector;
                IntVector valVector;
                LongBlock decimalsBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                decimalsBlock = (LongBlock)this.decimals.eval(page);
                                try {
                                    valVector = valBlock.asVector();
                                    if (valVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                                    if (decimalsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (decimalsBlock != null) {
                                        try {
                                            decimalsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                decimalsBlock.close();
                            }
                            return intBlock3;
                        }
                        decimalsVector = decimalsBlock.asVector();
                        if (decimalsVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                        if (decimalsBlock == null) break block19;
                        decimalsBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), valVector, decimalsVector).asBlock();
                if (decimalsBlock == null) break block20;
                decimalsBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.val.baseRamBytesUsed();
        return baseRamBytesUsed += this.decimals.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock valBlock, LongBlock decimalsBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.getValueCount(p) != 1) {
                    if (decimalsBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(Round.process(valBlock.getInt(valBlock.getFirstValueIndex(p)), decimalsBlock.getLong(decimalsBlock.getFirstValueIndex(p))));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector valVector, LongVector decimalsVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, Round.process(valVector.getInt(p), decimalsVector.getLong(p)));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "RoundIntEvaluator[val=" + String.valueOf(this.val) + ", decimals=" + String.valueOf(this.decimals) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.decimals});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final EvalOperator.ExpressionEvaluator.Factory decimals;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, EvalOperator.ExpressionEvaluator.Factory decimals) {
            this.source = source;
            this.val = val;
            this.decimals = decimals;
        }

        public RoundIntEvaluator get(DriverContext context) {
            return new RoundIntEvaluator(this.source, this.val.get(context), this.decimals.get(context), context);
        }

        public String toString() {
            return "RoundIntEvaluator[val=" + String.valueOf(this.val) + ", decimals=" + String.valueOf(this.decimals) + "]";
        }
    }
}

