/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.LogConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.LogEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Log
extends EsqlScalarFunction
implements OptionalArgument {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Log", Log::new);
    private final Expression base;
    private final Expression value;

    @FunctionInfo(returnType={"double"}, description="Returns the logarithm of a value to a base. The input can be any numeric value, the return value is always a double.\n\nLogs of zero, negative numbers, and base of one return `null` as well as a warning.", examples={@Example(file="math", tag="log"), @Example(file="math", tag="logUnary")})
    public Log(Source source, @Param(name="base", type={"integer", "unsigned_long", "long", "double"}, description="Base of logarithm. If `null`, the function returns `null`. If not provided, this function returns the natural logarithm (base e) of a value.", optional=true) Expression base, @Param(name="number", type={"integer", "unsigned_long", "long", "double"}, description="Numeric expression. If `null`, the function returns `null`.") Expression value) {
        super(source, value != null ? Arrays.asList(base, value) : Arrays.asList(base));
        this.value = value != null ? value : base;
        this.base = value != null ? base : null;
    }

    private Log(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readOptionalNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        assert (this.children().size() == 1 || this.children().size() == 2);
        out.writeNamedWriteable((NamedWriteable)this.children().get(0));
        out.writeOptionalNamedWriteable(this.children().size() == 2 ? (NamedWriteable)this.children().get(1) : null);
    }

    public String getWriteableName() {
        return Log.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.base != null && (resolution = TypeResolutions.isNumeric((Expression)this.base, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.value, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(this.base != null ? TypeResolutions.ParamOrdinal.SECOND : TypeResolutions.ParamOrdinal.FIRST));
    }

    public boolean foldable() {
        return (this.base == null || this.base.foldable()) && this.value.foldable();
    }

    static double process(double value) throws ArithmeticException {
        if (value <= 0.0) {
            throw new ArithmeticException("Log of non-positive number");
        }
        return Math.log(value);
    }

    static double process(double base, double value) throws ArithmeticException {
        if (base <= 0.0 || value <= 0.0) {
            throw new ArithmeticException("Log of non-positive number");
        }
        if (base == 1.0) {
            throw new ArithmeticException("Log of base 1");
        }
        return Math.log10(value) / Math.log10(base);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Log(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        Expression b = this.base != null ? this.base : this.value;
        Expression v = this.base != null ? this.value : null;
        return NodeInfo.create((Node)this, Log::new, (Object)b, (Object)v);
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory valueEval = Cast.cast(this.source(), this.value.dataType(), DataType.DOUBLE, toEvaluator.apply(this.value));
        if (this.base != null) {
            EvalOperator.ExpressionEvaluator.Factory baseEval = Cast.cast(this.source(), this.base.dataType(), DataType.DOUBLE, toEvaluator.apply(this.base));
            return new LogEvaluator.Factory(this.source(), baseEval, valueEval);
        }
        return new LogConstantEvaluator.Factory(this.source(), valueEval);
    }

    Expression value() {
        return this.value;
    }

    Expression base() {
        return this.base;
    }
}

