/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class FilteredExpression
extends Expression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "FilteredExpression", FilteredExpression::new);
    private final Expression delegate;
    private final Expression filter;

    public FilteredExpression(Source source, Expression delegate, Expression filter) {
        super(source, Arrays.asList(delegate, filter));
        this.delegate = delegate;
        this.filter = filter;
    }

    public FilteredExpression(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public Expression surrogate() {
        return (Expression)this.delegate.transformUp(AggregateFunction.class, af -> af.withFilter(this.filter));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.delegate);
        out.writeNamedWriteable((NamedWriteable)this.filter);
    }

    public String getWriteableName() {
        return FilteredExpression.ENTRY.name;
    }

    public Expression delegate() {
        return this.delegate;
    }

    public Expression filter() {
        return this.filter;
    }

    public DataType dataType() {
        return this.delegate.dataType();
    }

    public Nullability nullable() {
        return this.delegate.nullable();
    }

    protected NodeInfo<FilteredExpression> info() {
        return NodeInfo.create((Node)this, FilteredExpression::new, (Object)this.delegate, (Object)this.filter);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new FilteredExpression(this.source(), newChildren.get(0), newChildren.get(1));
    }
}

