/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator;

import java.util.List;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.esql.expression.predicate.logical.BinaryLogicOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.InsensitiveEqualsMapper;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.Layout;

public final class EvalMapper {
    private static final List<ExpressionMapper<?>> MAPPERS = List.of(new InsensitiveEqualsMapper(), new BooleanLogic(), new Attributes(), new Literals());

    private EvalMapper() {
    }

    public static EvalOperator.ExpressionEvaluator.Factory toEvaluator(FoldContext foldCtx, Expression exp, Layout layout) {
        return EvalMapper.toEvaluator(foldCtx, exp, layout, List.of());
    }

    public static EvalOperator.ExpressionEvaluator.Factory toEvaluator(final FoldContext foldCtx, Expression exp, final Layout layout, final List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
        if (exp instanceof EvaluatorMapper) {
            EvaluatorMapper m = (EvaluatorMapper)exp;
            return m.toEvaluator(new EvaluatorMapper.ToEvaluator(){

                @Override
                public EvalOperator.ExpressionEvaluator.Factory apply(Expression expression) {
                    return EvalMapper.toEvaluator(foldCtx, expression, layout, shardContexts);
                }

                @Override
                public FoldContext foldCtx() {
                    return foldCtx;
                }

                @Override
                public List<EsPhysicalOperationProviders.ShardContext> shardContexts() {
                    return shardContexts;
                }
            });
        }
        for (ExpressionMapper<?> em : MAPPERS) {
            if (!em.typeToken.isInstance(exp)) continue;
            return em.map(foldCtx, exp, layout, shardContexts);
        }
        throw new QlIllegalArgumentException("Unsupported expression [{}]", new Object[]{exp});
    }

    static class BooleanLogic
    extends ExpressionMapper<BinaryLogic> {
        BooleanLogic() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(FoldContext foldCtx, BinaryLogic bc, Layout layout, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
            EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(foldCtx, bc.left(), layout, shardContexts);
            EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(foldCtx, bc.right(), layout, shardContexts);
            return driverContext -> {
                record BooleanLogicExpressionEvaluator(BinaryLogic bl, EvalOperator.ExpressionEvaluator leftEval, EvalOperator.ExpressionEvaluator rightEval) implements EvalOperator.ExpressionEvaluator
                {
                    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BooleanLogicExpressionEvaluator.class);

                    public Block eval(Page page) {
                        try (Block lhs = this.leftEval.eval(page);){
                            Block block;
                            block16: {
                                Block rhs;
                                block14: {
                                    Block block2;
                                    block15: {
                                        rhs = this.rightEval.eval(page);
                                        try {
                                            Vector lhsVector = lhs.asVector();
                                            Vector rhsVector = rhs.asVector();
                                            if (lhsVector == null || rhsVector == null) break block14;
                                            block2 = this.eval((BooleanVector)lhsVector, (BooleanVector)rhsVector);
                                            if (rhs == null) break block15;
                                        }
                                        catch (Throwable throwable) {
                                            if (rhs != null) {
                                                try {
                                                    rhs.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        rhs.close();
                                    }
                                    return block2;
                                }
                                block = this.eval(lhs, rhs);
                                if (rhs == null) break block16;
                                rhs.close();
                            }
                            return block;
                        }
                    }

                    public long baseRamBytesUsed() {
                        return BASE_RAM_BYTES_USED;
                    }

                    private Block eval(Block lhs, Block rhs) {
                        int positionCount = lhs.getPositionCount();
                        try (BooleanBlock.Builder result = lhs.blockFactory().newBooleanBlockBuilder(positionCount);){
                            for (int p = 0; p < positionCount; ++p) {
                                if (lhs.getValueCount(p) > 1) {
                                    result.appendNull();
                                    continue;
                                }
                                if (rhs.getValueCount(p) > 1) {
                                    result.appendNull();
                                    continue;
                                }
                                Boolean v = ((BinaryLogicOperation)this.bl.function()).apply(lhs.isNull(p) ? null : Boolean.valueOf(((BooleanBlock)lhs).getBoolean(lhs.getFirstValueIndex(p))), rhs.isNull(p) ? null : Boolean.valueOf(((BooleanBlock)rhs).getBoolean(rhs.getFirstValueIndex(p))));
                                if (v == null) {
                                    result.appendNull();
                                    continue;
                                }
                                result.appendBoolean(v.booleanValue());
                            }
                            BooleanBlock booleanBlock = result.build();
                            return booleanBlock;
                        }
                    }

                    private Block eval(BooleanVector lhs, BooleanVector rhs) {
                        int positionCount = lhs.getPositionCount();
                        try (BooleanVector.FixedBuilder result = lhs.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
                            for (int p = 0; p < positionCount; ++p) {
                                result.appendBoolean(p, ((BinaryLogicOperation)this.bl.function()).apply(lhs.getBoolean(p), rhs.getBoolean(p)).booleanValue());
                            }
                            BooleanBlock booleanBlock = result.build().asBlock();
                            return booleanBlock;
                        }
                    }

                    public void close() {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.leftEval, this.rightEval});
                    }
                }
                return new BooleanLogicExpressionEvaluator(bc, leftEval.get(driverContext), rightEval.get(driverContext));
            };
        }
    }

    static class Attributes
    extends ExpressionMapper<Attribute> {
        Attributes() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(FoldContext foldCtx, Attribute attr, Layout layout, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
            record AttributeFactory(int channel) implements EvalOperator.ExpressionEvaluator.Factory
            {
                public EvalOperator.ExpressionEvaluator get(DriverContext driverContext) {
                    record Attribute(int channel) implements EvalOperator.ExpressionEvaluator
                    {
                        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Attribute.class);

                        public Block eval(Page page) {
                            Block block = page.getBlock(this.channel);
                            block.incRef();
                            return block;
                        }

                        public long baseRamBytesUsed() {
                            return BASE_RAM_BYTES_USED;
                        }

                        public void close() {
                        }
                    }
                    return new Attribute(this.channel);
                }

                @Override
                public String toString() {
                    return "Attribute[channel=" + this.channel + "]";
                }

                public boolean eagerEvalSafeInLazy() {
                    return true;
                }
            }
            return new AttributeFactory(layout.get(attr.id()).channel());
        }
    }

    static class Literals
    extends ExpressionMapper<Literal> {
        Literals() {
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory map(FoldContext foldCtx, Literal lit, Layout layout, List<EsPhysicalOperationProviders.ShardContext> shardContexts) {
            record LiteralsEvaluatorFactory(Literal lit) implements EvalOperator.ExpressionEvaluator.Factory
            {
                public EvalOperator.ExpressionEvaluator get(DriverContext driverContext) {
                    record LiteralsEvaluator(DriverContext context, Literal lit) implements EvalOperator.ExpressionEvaluator
                    {
                        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LiteralsEvaluator.class);

                        public Block eval(Page page) {
                            return Literals.block(this.lit, this.context.blockFactory(), page.getPositionCount());
                        }

                        @Override
                        public String toString() {
                            return "LiteralsEvaluator[lit=" + String.valueOf(this.lit) + "]";
                        }

                        public long baseRamBytesUsed() {
                            return BASE_RAM_BYTES_USED + this.lit.ramBytesUsed();
                        }

                        public void close() {
                        }
                    }
                    return new LiteralsEvaluator(driverContext, this.lit);
                }

                @Override
                public String toString() {
                    return "LiteralsEvaluator[lit=" + String.valueOf(this.lit) + "]";
                }

                public boolean eagerEvalSafeInLazy() {
                    return true;
                }
            }
            return new LiteralsEvaluatorFactory(lit);
        }

        private static Block block(Literal lit, BlockFactory blockFactory, int positions) {
            Object value = lit.value();
            if (value == null) {
                return blockFactory.newConstantNullBlock(positions);
            }
            if (value instanceof List) {
                List multiValue = (List)value;
                if (multiValue.isEmpty()) {
                    return blockFactory.newConstantNullBlock(positions);
                }
                BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)ElementType.fromJava(multiValue.get(0).getClass()), (int)positions);
                for (int i = 0; i < positions; ++i) {
                    wrapper.accept((Object)multiValue);
                }
                return wrapper.builder().build();
            }
            return BlockUtils.constantBlock((BlockFactory)blockFactory, (Object)value, (int)positions);
        }
    }
}

