/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.action.GetQueryRulesetAction;
import org.elasticsearch.xpack.application.rules.action.TestQueryRulesetAction;
import org.elasticsearch.xpack.core.ClientHelper;

public class TransportTestQueryRulesetAction
extends HandledTransportAction<TestQueryRulesetAction.Request, TestQueryRulesetAction.Response> {
    private final Client client;

    @Inject
    public TransportTestQueryRulesetAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super(TestQueryRulesetAction.NAME, transportService, actionFilters, TestQueryRulesetAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
    }

    protected void doExecute(Task task, TestQueryRulesetAction.Request request, ActionListener<TestQueryRulesetAction.Response> listener) {
        GetQueryRulesetAction.Request getQueryRulesetRequest = new GetQueryRulesetAction.Request(request.rulesetId());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"enterprise_search", GetQueryRulesetAction.TYPE, (ActionRequest)getQueryRulesetRequest, (ActionListener)ActionListener.wrap(getQueryRulesetResponse -> {
            ArrayList<TestQueryRulesetAction.MatchedRule> matchedRules = new ArrayList<TestQueryRulesetAction.MatchedRule>();
            for (QueryRule rule : getQueryRulesetResponse.queryRuleset().rules()) {
                if (!rule.isRuleMatch(request.matchCriteria())) continue;
                matchedRules.add(new TestQueryRulesetAction.MatchedRule(request.rulesetId(), rule.id()));
            }
            listener.onResponse((Object)new TestQueryRulesetAction.Response(matchedRules.size(), matchedRules));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

