/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;
import org.elasticsearch.xpack.application.connector.syncjob.action.ListConnectorSyncJobsAction;
import org.elasticsearch.xpack.core.action.util.PageParams;

@ServerlessScope(value=Scope.PUBLIC)
public class RestListConnectorSyncJobsAction
extends BaseRestHandler {
    public String getName() {
        return "connector_sync_jobs_list_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_connector/_sync_job"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        int from = restRequest.paramAsInt("from", 0);
        int size = restRequest.paramAsInt("size", 100);
        String connectorId = restRequest.param(ListConnectorSyncJobsAction.Request.CONNECTOR_ID_FIELD.getPreferredName());
        String statusString = restRequest.param(ConnectorSyncJob.STATUS_FIELD.getPreferredName());
        ConnectorSyncStatus status = statusString != null ? ConnectorSyncStatus.fromString(statusString) : null;
        String[] jobTypeStringArray = restRequest.paramAsStringArray(ConnectorSyncJob.JOB_TYPE_FIELD.getPreferredName(), null);
        List<ConnectorSyncJobType> jobTypeList = jobTypeStringArray != null ? Arrays.stream(jobTypeStringArray).map(ConnectorSyncJobType::fromString).toList() : null;
        ListConnectorSyncJobsAction.Request request = new ListConnectorSyncJobsAction.Request(new PageParams(from, size), connectorId, status, jobTypeList);
        return channel -> client.execute(ListConnectorSyncJobsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

