/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorConfiguration;
import org.elasticsearch.xpack.application.connector.ConnectorIngestPipeline;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.ConnectorUtils;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobTriggerMethod;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;

public class ConnectorSyncJob
implements Writeable,
ToXContentObject {
    static final ParseField CANCELATION_REQUESTED_AT_FIELD = new ParseField("cancelation_requested_at", new String[0]);
    static final ParseField CANCELED_AT_FIELD = new ParseField("canceled_at", new String[0]);
    static final ParseField COMPLETED_AT_FIELD = new ParseField("completed_at", new String[0]);
    static final ParseField CONNECTOR_FIELD = new ParseField("connector", new String[0]);
    static final ParseField CREATED_AT_FIELD = new ParseField("created_at", new String[0]);
    public static final ParseField DELETED_DOCUMENT_COUNT_FIELD = new ParseField("deleted_document_count", new String[0]);
    public static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    public static final ParseField INDEXED_DOCUMENT_COUNT_FIELD = new ParseField("indexed_document_count", new String[0]);
    public static final ParseField INDEXED_DOCUMENT_VOLUME_FIELD = new ParseField("indexed_document_volume", new String[0]);
    public static final ParseField JOB_TYPE_FIELD = new ParseField("job_type", new String[0]);
    public static final ParseField LAST_SEEN_FIELD = new ParseField("last_seen", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("metadata", new String[0]);
    static final ParseField STARTED_AT_FIELD = new ParseField("started_at", new String[0]);
    public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
    public static final ParseField TOTAL_DOCUMENT_COUNT_FIELD = new ParseField("total_document_count", new String[0]);
    public static final ParseField TRIGGER_METHOD_FIELD = new ParseField("trigger_method", new String[0]);
    public static final ParseField WORKER_HOSTNAME_FIELD = new ParseField("worker_hostname", new String[0]);
    static final ConnectorSyncStatus DEFAULT_INITIAL_STATUS = ConnectorSyncStatus.PENDING;
    static final ConnectorSyncJobType DEFAULT_JOB_TYPE = ConnectorSyncJobType.FULL;
    static final ConnectorSyncJobTriggerMethod DEFAULT_TRIGGER_METHOD = ConnectorSyncJobTriggerMethod.ON_DEMAND;
    @Nullable
    private final Instant cancelationRequestedAt;
    @Nullable
    private final Instant canceledAt;
    @Nullable
    private final Instant completedAt;
    private final Connector connector;
    private final Instant createdAt;
    private final long deletedDocumentCount;
    @Nullable
    private final String error;
    private final String id;
    private final long indexedDocumentCount;
    private final long indexedDocumentVolume;
    private final ConnectorSyncJobType jobType;
    @Nullable
    private final Instant lastSeen;
    private final Map<String, Object> metadata;
    @Nullable
    private final Instant startedAt;
    private final ConnectorSyncStatus status;
    private final long totalDocumentCount;
    private final ConnectorSyncJobTriggerMethod triggerMethod;
    @Nullable
    private final String workerHostname;
    private static final ConstructingObjectParser<ConnectorSyncJob, String> PARSER = new ConstructingObjectParser("connector_sync_job", true, (args, docId) -> {
        int i = 0;
        return new Builder().setCancellationRequestedAt((Instant)args[i++]).setCanceledAt((Instant)args[i++]).setCompletedAt((Instant)args[i++]).setConnector((Connector)args[i++]).setCreatedAt((Instant)args[i++]).setDeletedDocumentCount((Long)args[i++]).setError((String)args[i++]).setId((String)docId).setIndexedDocumentCount((Long)args[i++]).setIndexedDocumentVolume((Long)args[i++]).setJobType((ConnectorSyncJobType)((Object)((Object)args[i++]))).setLastSeen((Instant)args[i++]).setMetadata((Map)args[i++]).setStartedAt((Instant)args[i++]).setStatus((ConnectorSyncStatus)((Object)((Object)args[i++]))).setTotalDocumentCount((Long)args[i++]).setTriggerMethod((ConnectorSyncJobTriggerMethod)((Object)((Object)args[i++]))).setWorkerHostname((String)args[i]).build();
    });
    private static final ConstructingObjectParser<Connector, String> SYNC_JOB_CONNECTOR_PARSER;

    private ConnectorSyncJob(Instant cancelationRequestedAt, Instant canceledAt, Instant completedAt, Connector connector, Instant createdAt, long deletedDocumentCount, String error, String id, long indexedDocumentCount, long indexedDocumentVolume, ConnectorSyncJobType jobType, Instant lastSeen, Map<String, Object> metadata, Instant startedAt, ConnectorSyncStatus status, long totalDocumentCount, ConnectorSyncJobTriggerMethod triggerMethod, String workerHostname) {
        this.cancelationRequestedAt = cancelationRequestedAt;
        this.canceledAt = canceledAt;
        this.completedAt = completedAt;
        this.connector = connector;
        this.createdAt = createdAt;
        this.deletedDocumentCount = deletedDocumentCount;
        this.error = error;
        this.id = id;
        this.indexedDocumentCount = indexedDocumentCount;
        this.indexedDocumentVolume = indexedDocumentVolume;
        this.jobType = Objects.requireNonNullElse(jobType, ConnectorSyncJobType.FULL);
        this.lastSeen = lastSeen;
        this.metadata = Objects.requireNonNullElse(metadata, Collections.emptyMap());
        this.startedAt = startedAt;
        this.status = status;
        this.totalDocumentCount = totalDocumentCount;
        this.triggerMethod = Objects.requireNonNullElse(triggerMethod, ConnectorSyncJobTriggerMethod.ON_DEMAND);
        this.workerHostname = workerHostname;
    }

    public ConnectorSyncJob(StreamInput in) throws IOException {
        this.cancelationRequestedAt = in.readOptionalInstant();
        this.canceledAt = in.readOptionalInstant();
        this.completedAt = in.readOptionalInstant();
        this.connector = (Connector)in.readNamedWriteable(Connector.class);
        this.createdAt = in.readInstant();
        this.deletedDocumentCount = in.readLong();
        this.error = in.readOptionalString();
        this.id = in.readString();
        this.indexedDocumentCount = in.readLong();
        this.indexedDocumentVolume = in.readLong();
        this.jobType = (ConnectorSyncJobType)in.readEnum(ConnectorSyncJobType.class);
        this.lastSeen = in.readOptionalInstant();
        this.metadata = in.readMap(StreamInput::readString, StreamInput::readGenericValue);
        this.startedAt = in.readOptionalInstant();
        this.status = (ConnectorSyncStatus)in.readEnum(ConnectorSyncStatus.class);
        this.totalDocumentCount = in.readOptionalLong();
        this.triggerMethod = (ConnectorSyncJobTriggerMethod)in.readEnum(ConnectorSyncJobTriggerMethod.class);
        this.workerHostname = in.readOptionalString();
    }

    public static ConnectorSyncJob fromXContentBytes(BytesReference source, String docId, XContentType xContentType) {
        ConnectorSyncJob connectorSyncJob;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connectorSyncJob = ConnectorSyncJob.fromXContent(parser, docId);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector sync job document.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connectorSyncJob;
    }

    public static ConnectorSyncJob fromXContent(XContentParser parser, String docId) throws IOException {
        return (ConnectorSyncJob)PARSER.parse(parser, (Object)docId);
    }

    public static Connector syncJobConnectorFromXContentBytes(BytesReference source, String connectorId, XContentType xContentType) {
        Connector connector;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                connector = ConnectorSyncJob.syncJobConnectorFromXContent(parser, connectorId);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse a connector document.", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return connector;
    }

    public static Connector syncJobConnectorFromXContent(XContentParser parser, String connectorId) throws IOException {
        return (Connector)SYNC_JOB_CONNECTOR_PARSER.parse(parser, (Object)connectorId);
    }

    public String getId() {
        return this.id;
    }

    public Instant getCancelationRequestedAt() {
        return this.cancelationRequestedAt;
    }

    public Instant getCanceledAt() {
        return this.canceledAt;
    }

    public Instant getCompletedAt() {
        return this.completedAt;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public long getDeletedDocumentCount() {
        return this.deletedDocumentCount;
    }

    public String getError() {
        return this.error;
    }

    public long getIndexedDocumentCount() {
        return this.indexedDocumentCount;
    }

    public long getIndexedDocumentVolume() {
        return this.indexedDocumentVolume;
    }

    public ConnectorSyncJobType getJobType() {
        return this.jobType;
    }

    public Instant getLastSeen() {
        return this.lastSeen;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getStartedAt() {
        return this.startedAt;
    }

    public ConnectorSyncStatus getStatus() {
        return this.status;
    }

    public long getTotalDocumentCount() {
        return this.totalDocumentCount;
    }

    public ConnectorSyncJobTriggerMethod getTriggerMethod() {
        return this.triggerMethod;
    }

    public String getWorkerHostname() {
        return this.workerHostname;
    }

    public void toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.cancelationRequestedAt != null) {
            builder.field(CANCELATION_REQUESTED_AT_FIELD.getPreferredName(), (Object)this.cancelationRequestedAt);
        }
        if (this.canceledAt != null) {
            builder.field(CANCELED_AT_FIELD.getPreferredName(), (Object)this.canceledAt);
        }
        if (this.completedAt != null) {
            builder.field(COMPLETED_AT_FIELD.getPreferredName(), (Object)this.completedAt);
        }
        builder.startObject(CONNECTOR_FIELD.getPreferredName());
        if (this.connector.getConnectorId() != null) {
            builder.field(Connector.ID_FIELD.getPreferredName(), this.connector.getConnectorId());
        }
        if (this.connector.getSyncJobFiltering() != null) {
            builder.field(Connector.FILTERING_FIELD.getPreferredName(), (ToXContent)this.connector.getSyncJobFiltering());
        }
        if (this.connector.getIndexName() != null) {
            builder.field(Connector.INDEX_NAME_FIELD.getPreferredName(), this.connector.getIndexName());
        }
        if (this.connector.getLanguage() != null) {
            builder.field(Connector.LANGUAGE_FIELD.getPreferredName(), this.connector.getLanguage());
        }
        if (this.connector.getPipeline() != null) {
            builder.field(Connector.PIPELINE_FIELD.getPreferredName(), (ToXContent)this.connector.getPipeline());
        }
        if (this.connector.getServiceType() != null) {
            builder.field(Connector.SERVICE_TYPE_FIELD.getPreferredName(), this.connector.getServiceType());
        }
        if (this.connector.getConfiguration() != null) {
            builder.field(Connector.CONFIGURATION_FIELD.getPreferredName(), this.connector.getConfiguration());
        }
        builder.endObject();
        builder.field(CREATED_AT_FIELD.getPreferredName(), (Object)this.createdAt);
        builder.field(DELETED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.deletedDocumentCount);
        if (this.error != null) {
            builder.field(ERROR_FIELD.getPreferredName(), this.error);
        }
        builder.field(INDEXED_DOCUMENT_COUNT_FIELD.getPreferredName(), this.indexedDocumentCount);
        builder.field(INDEXED_DOCUMENT_VOLUME_FIELD.getPreferredName(), this.indexedDocumentVolume);
        builder.field(JOB_TYPE_FIELD.getPreferredName(), (Enum)this.jobType);
        if (this.lastSeen != null) {
            builder.field(LAST_SEEN_FIELD.getPreferredName(), (Object)this.lastSeen);
        }
        builder.field(METADATA_FIELD.getPreferredName(), this.metadata);
        if (this.startedAt != null) {
            builder.field(STARTED_AT_FIELD.getPreferredName(), (Object)this.startedAt);
        }
        builder.field(STATUS_FIELD.getPreferredName(), (Enum)this.status);
        builder.field(TOTAL_DOCUMENT_COUNT_FIELD.getPreferredName(), this.totalDocumentCount);
        builder.field(TRIGGER_METHOD_FIELD.getPreferredName(), (Enum)this.triggerMethod);
        if (this.workerHostname != null) {
            builder.field(WORKER_HOSTNAME_FIELD.getPreferredName(), this.workerHostname);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInstant(this.cancelationRequestedAt);
        out.writeOptionalInstant(this.canceledAt);
        out.writeOptionalInstant(this.completedAt);
        out.writeNamedWriteable((NamedWriteable)this.connector);
        out.writeInstant(this.createdAt);
        out.writeLong(this.deletedDocumentCount);
        out.writeOptionalString(this.error);
        out.writeString(this.id);
        out.writeLong(this.indexedDocumentCount);
        out.writeLong(this.indexedDocumentVolume);
        out.writeEnum((Enum)this.jobType);
        out.writeOptionalInstant(this.lastSeen);
        out.writeMap(this.metadata, StreamOutput::writeString, StreamOutput::writeGenericValue);
        out.writeOptionalInstant(this.startedAt);
        out.writeEnum((Enum)this.status);
        out.writeOptionalLong(Long.valueOf(this.totalDocumentCount));
        out.writeEnum((Enum)this.triggerMethod);
        out.writeOptionalString(this.workerHostname);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConnectorSyncJob connectorSyncJob = (ConnectorSyncJob)other;
        return Objects.equals(this.cancelationRequestedAt, connectorSyncJob.cancelationRequestedAt) && Objects.equals(this.canceledAt, connectorSyncJob.canceledAt) && Objects.equals(this.completedAt, connectorSyncJob.completedAt) && Objects.equals(this.connector, connectorSyncJob.connector) && Objects.equals(this.createdAt, connectorSyncJob.createdAt) && Objects.equals(this.deletedDocumentCount, connectorSyncJob.deletedDocumentCount) && Objects.equals(this.error, connectorSyncJob.error) && Objects.equals(this.id, connectorSyncJob.id) && Objects.equals(this.indexedDocumentCount, connectorSyncJob.indexedDocumentCount) && Objects.equals(this.indexedDocumentVolume, connectorSyncJob.indexedDocumentVolume) && Objects.equals((Object)this.jobType, (Object)connectorSyncJob.jobType) && Objects.equals(this.lastSeen, connectorSyncJob.lastSeen) && Objects.equals(this.metadata, connectorSyncJob.metadata) && Objects.equals(this.startedAt, connectorSyncJob.startedAt) && Objects.equals((Object)this.status, (Object)connectorSyncJob.status) && Objects.equals(this.totalDocumentCount, connectorSyncJob.totalDocumentCount) && Objects.equals((Object)this.triggerMethod, (Object)connectorSyncJob.triggerMethod) && Objects.equals(this.workerHostname, connectorSyncJob.workerHostname);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cancelationRequestedAt, this.canceledAt, this.completedAt, this.connector, this.createdAt, this.deletedDocumentCount, this.error, this.id, this.indexedDocumentCount, this.indexedDocumentVolume, this.jobType, this.lastSeen, this.metadata, this.startedAt, this.status, this.totalDocumentCount, this.triggerMethod, this.workerHostname});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, CANCELATION_REQUESTED_AT_FIELD.getPreferredName()), CANCELATION_REQUESTED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, CANCELED_AT_FIELD.getPreferredName()), CANCELED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, COMPLETED_AT_FIELD.getPreferredName()), COMPLETED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorSyncJob.syncJobConnectorFromXContent(p, null), CONNECTOR_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorUtils.parseInstant(p, CREATED_AT_FIELD.getPreferredName()), CREATED_AT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), DELETED_DOCUMENT_COUNT_FIELD);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEXED_DOCUMENT_COUNT_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), INDEXED_DOCUMENT_VOLUME_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorSyncJobType.fromString(p.text()), JOB_TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, LAST_SEEN_FIELD.getPreferredName()), LAST_SEEN_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), METADATA_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorUtils.parseNullableInstant(p, STARTED_AT_FIELD.getPreferredName()), STARTED_AT_FIELD, ObjectParser.ValueType.STRING_OR_NULL);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorSyncStatus.fromString(p.text()), STATUS_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareLongOrNull(ConstructingObjectParser.constructorArg(), 0L, TOTAL_DOCUMENT_COUNT_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> ConnectorSyncJobTriggerMethod.fromString(p.text()), TRIGGER_METHOD_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), WORKER_HOSTNAME_FIELD);
        SYNC_JOB_CONNECTOR_PARSER = new ConstructingObjectParser("sync_job_connector", true, (args, connectorId) -> {
            int i = 0;
            String parsedConnectorId = (String)args[i++];
            String syncJobConnectorId = Strings.isNullOrEmpty((String)connectorId) ? parsedConnectorId : connectorId;
            return new Connector.Builder().setConnectorId(syncJobConnectorId).setSyncJobFiltering((FilteringRules)args[i++]).setIndexName((String)args[i++]).setLanguage((String)args[i++]).setPipeline((ConnectorIngestPipeline)args[i++]).setServiceType((String)args[i++]).setConfiguration((Map)args[i++]).build();
        });
        SYNC_JOB_CONNECTOR_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Connector.ID_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> FilteringRules.fromXContent(p), null, Connector.FILTERING_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.INDEX_NAME_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.LANGUAGE_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorIngestPipeline.fromXContent(p), null, Connector.PIPELINE_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), Connector.SERVICE_TYPE_FIELD);
        SYNC_JOB_CONNECTOR_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(HashMap::new, ConnectorConfiguration::fromXContent), Connector.CONFIGURATION_FIELD);
    }

    public static class Builder {
        private Instant cancellationRequestedAt;
        private Instant canceledAt;
        private Instant completedAt;
        private Connector connector;
        private Instant createdAt;
        private long deletedDocumentCount;
        private String error;
        private String id;
        private long indexedDocumentCount;
        private long indexedDocumentVolume;
        private ConnectorSyncJobType jobType;
        private Instant lastSeen;
        private Map<String, Object> metadata;
        private Instant startedAt;
        private ConnectorSyncStatus status;
        private long totalDocumentCount;
        private ConnectorSyncJobTriggerMethod triggerMethod;
        private String workerHostname;

        public Builder setCancellationRequestedAt(Instant cancellationRequestedAt) {
            this.cancellationRequestedAt = cancellationRequestedAt;
            return this;
        }

        public Builder setCanceledAt(Instant canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder setConnector(Connector connector) {
            this.connector = connector;
            return this;
        }

        public Builder setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setDeletedDocumentCount(long deletedDocumentCount) {
            this.deletedDocumentCount = deletedDocumentCount;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setIndexedDocumentCount(long indexedDocumentCount) {
            this.indexedDocumentCount = indexedDocumentCount;
            return this;
        }

        public Builder setIndexedDocumentVolume(long indexedDocumentVolume) {
            this.indexedDocumentVolume = indexedDocumentVolume;
            return this;
        }

        public Builder setJobType(ConnectorSyncJobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public Builder setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public Builder setStatus(ConnectorSyncStatus status) {
            this.status = status;
            return this;
        }

        public Builder setTotalDocumentCount(long totalDocumentCount) {
            this.totalDocumentCount = totalDocumentCount;
            return this;
        }

        public Builder setTriggerMethod(ConnectorSyncJobTriggerMethod triggerMethod) {
            this.triggerMethod = triggerMethod;
            return this;
        }

        public Builder setWorkerHostname(String workerHostname) {
            this.workerHostname = workerHostname;
            return this;
        }

        public ConnectorSyncJob build() {
            return new ConnectorSyncJob(this.cancellationRequestedAt, this.canceledAt, this.completedAt, this.connector, this.createdAt, this.deletedDocumentCount, this.error, this.id, this.indexedDocumentCount, this.indexedDocumentVolume, this.jobType, this.lastSeen, this.metadata, this.startedAt, this.status, this.totalDocumentCount, this.triggerMethod, this.workerHostname);
        }
    }
}

