/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorLastSeenAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_last_seen";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_last_seen");

    private UpdateConnectorLastSeenAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;

        public Request(String connectorId) {
            this.connectorId = connectorId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.ID_FIELD.getPreferredName(), this.connectorId);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId);
        }
    }
}

