/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageBlobStore;

class GoogleCloudStorageBlobContainer
extends AbstractBlobContainer {
    private final GoogleCloudStorageBlobStore blobStore;
    private final String path;

    GoogleCloudStorageBlobContainer(BlobPath path, GoogleCloudStorageBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.path = path.buildAsString();
    }

    public boolean blobExists(OperationPurpose purpose, String blobName) {
        try {
            return this.blobStore.blobExists(this.buildKey(blobName));
        }
        catch (Exception e) {
            throw new BlobStoreException("Failed to check if blob [" + blobName + "] exists", (Throwable)e);
        }
    }

    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        return this.blobStore.listBlobs(this.path);
    }

    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        return this.blobStore.listChildren(this.path());
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, String prefix) throws IOException {
        return this.blobStore.listBlobsByPrefix(this.path, prefix);
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
        return this.blobStore.readBlob(this.buildKey(blobName));
    }

    public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
        return this.blobStore.readBlob(this.buildKey(blobName), position, length);
    }

    public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize, failIfAlreadyExists);
    }

    public void writeBlob(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), bytes, failIfAlreadyExists);
    }

    public void writeMetadataBlob(OperationPurpose purpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), failIfAlreadyExists, writer);
    }

    public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(purpose, blobName, bytes, failIfAlreadyExists);
    }

    public DeleteResult delete(OperationPurpose purpose) throws IOException {
        return this.blobStore.deleteDirectory(this.path().buildAsString());
    }

    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, final Iterator<String> blobNames) throws IOException {
        this.blobStore.deleteBlobs(new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return blobNames.hasNext();
            }

            @Override
            public String next() {
                return GoogleCloudStorageBlobContainer.this.buildKey((String)blobNames.next());
            }
        });
    }

    private String buildKey(String blobName) {
        assert (blobName != null);
        return this.path + blobName;
    }

    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        if (GoogleCloudStorageBlobContainer.skipCas(listener)) {
            return;
        }
        ActionListener.completeWith(listener, () -> this.blobStore.compareAndExchangeRegister(this.buildKey(key), this.path, key, expected, updated));
    }

    public void getRegister(OperationPurpose purpose, String key, ActionListener<OptionalBytesReference> listener) {
        if (GoogleCloudStorageBlobContainer.skipCas(listener)) {
            return;
        }
        ActionListener.completeWith(listener, () -> this.blobStore.getRegister(this.buildKey(key), this.path, key));
    }
}

