/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.rate.AbstractRateAggregator;
import org.elasticsearch.xpack.analytics.rate.RateMode;

public class NumericRateAggregator
extends AbstractRateAggregator {
    private final DocCountProvider docCountProvider;

    public NumericRateAggregator(String name, ValuesSourceConfig valuesSourceConfig, Rounding.DateTimeUnit rateUnit, RateMode rateMode, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, rateUnit, rateMode, context, parent, metadata);
        this.docCountProvider = this.computeWithDocCount ? new DocCountProvider() : null;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        if (this.computeWithDocCount) {
            this.docCountProvider.setLeafReaderContext(aggCtx.getLeafReaderContext());
            return new LeafBucketCollectorBase(sub, null){

                public void collect(int doc, long bucket) throws IOException {
                    NumericRateAggregator.this.sums = NumericRateAggregator.this.bigArrays().grow(NumericRateAggregator.this.sums, bucket + 1L);
                    NumericRateAggregator.this.compensations = NumericRateAggregator.this.bigArrays().grow(NumericRateAggregator.this.compensations, bucket + 1L);
                    double sum = NumericRateAggregator.this.sums.get(bucket);
                    double compensation = NumericRateAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    int docCount = NumericRateAggregator.this.docCountProvider.getDocCount(doc);
                    kahanSummation.add((double)docCount);
                    NumericRateAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    NumericRateAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            };
        }
        final SortedNumericDoubleValues values = ((ValuesSource.Numeric)this.valuesSource).doubleValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    NumericRateAggregator.this.sums = NumericRateAggregator.this.bigArrays().grow(NumericRateAggregator.this.sums, bucket + 1L);
                    NumericRateAggregator.this.compensations = NumericRateAggregator.this.bigArrays().grow(NumericRateAggregator.this.compensations, bucket + 1L);
                    int valuesCount = values.docValueCount();
                    double sum = NumericRateAggregator.this.sums.get(bucket);
                    double compensation = NumericRateAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    switch (NumericRateAggregator.this.rateMode) {
                        case SUM: {
                            for (int i = 0; i < valuesCount; ++i) {
                                kahanSummation.add(values.nextValue());
                            }
                            break;
                        }
                        case VALUE_COUNT: {
                            kahanSummation.add((double)valuesCount);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported rate mode " + String.valueOf((Object)NumericRateAggregator.this.rateMode));
                        }
                    }
                    NumericRateAggregator.this.compensations.set(bucket, kahanSummation.delta());
                    NumericRateAggregator.this.sums.set(bucket, kahanSummation.value());
                }
            }
        };
    }
}

