/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.scanner;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.plugin.scanner.AnnotatedHierarchyVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassScanner {
    private final Map<String, String> foundClasses = new HashMap<String, String>();
    private final AnnotatedHierarchyVisitor annotatedHierarchyVisitor;

    public ClassScanner(String targetAnnotation, BiFunction<String, Map<String, String>, AnnotationVisitor> biConsumer) {
        this.annotatedHierarchyVisitor = new AnnotatedHierarchyVisitor(targetAnnotation, classname -> (AnnotationVisitor)biConsumer.apply((String)classname, this.foundClasses));
    }

    public void visit(List<ClassReader> classReaders) {
        classReaders.forEach(classReader -> classReader.accept((ClassVisitor)this.annotatedHierarchyVisitor, 1));
        this.addExtensibleDescendants(this.annotatedHierarchyVisitor.getClassHierarchy());
    }

    public void addExtensibleDescendants(Map<String, Set<String>> classToSubclasses) {
        ArrayDeque<Map.Entry<String, String>> toCheckDescendants = new ArrayDeque<Map.Entry<String, String>>(this.foundClasses.entrySet());
        HashSet<String> processed = new HashSet<String>();
        while (!toCheckDescendants.isEmpty()) {
            Set<String> subclasses;
            Map.Entry e = (Map.Entry)toCheckDescendants.removeFirst();
            String classname = (String)e.getKey();
            if (processed.contains(classname) || (subclasses = classToSubclasses.get(classname)) == null) continue;
            for (String subclass : subclasses) {
                this.foundClasses.put(subclass, (String)e.getValue());
                toCheckDescendants.addLast(Map.entry(subclass, (String)e.getValue()));
            }
            processed.add(classname);
        }
    }

    public Map<String, String> getFoundClasses() {
        return this.foundClasses;
    }
}

