/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule.support;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class TimezoneUtils {
    private static final Map<String, ZoneId> caseInsensitiveTZLookup = ZoneId.getAvailableZoneIds().stream().collect(Collectors.toMap(zoneId -> zoneId.toLowerCase(Locale.ROOT), ZoneId::of));

    public static ZoneId parse(String timezoneString) throws DateTimeException {
        try {
            return ZoneId.of(timezoneString);
        }
        catch (DateTimeException e) {
            ZoneId timeZone = caseInsensitiveTZLookup.get(timezoneString.toLowerCase(Locale.ROOT));
            if (timeZone != null) {
                return timeZone;
            }
            try {
                return ZoneId.of(timezoneString.toUpperCase(Locale.ROOT));
            }
            catch (DateTimeException dateTimeException) {
                throw e;
            }
        }
    }
}

