/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email.attachment;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.notification.email.Attachment;
import org.elasticsearch.xpack.watcher.notification.email.attachment.DataAttachment;
import org.elasticsearch.xpack.watcher.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.support.Variables;

public class DataAttachmentParser
implements EmailAttachmentParser<DataAttachment> {
    public static final String TYPE = "data";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public DataAttachment parse(String id, XContentParser parser) throws IOException {
        XContentParser.Token token;
        org.elasticsearch.xpack.watcher.notification.email.DataAttachment dataAttachment = org.elasticsearch.xpack.watcher.notification.email.DataAttachment.YAML;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!Strings.hasLength(currentFieldName) || !Fields.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                dataAttachment = org.elasticsearch.xpack.watcher.notification.email.DataAttachment.resolve(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse data attachment. expected string value for [{}] field but found [{}] instead", new Object[]{currentFieldName, token});
        }
        return new DataAttachment(id, dataAttachment);
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext ctx, Payload payload, DataAttachment attachment) throws IOException {
        Map<String, Object> model = Variables.createCtxParamsMap(ctx, payload);
        return attachment.getDataAttachment().create(attachment.id(), model);
    }

    static interface Fields {
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

