/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.simdvec;

import java.util.Optional;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.FilterIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MemorySegmentAccessInput;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.RandomAccessQuantizedByteVectorValues;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.simdvec.VectorScorerFactory;
import org.elasticsearch.simdvec.VectorSimilarityType;
import org.elasticsearch.simdvec.internal.Int7SQVectorScorer;
import org.elasticsearch.simdvec.internal.Int7SQVectorScorerSupplier;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class VectorScorerFactoryImpl
implements VectorScorerFactory {
    static final VectorScorerFactoryImpl INSTANCE = NativeAccess.instance().getVectorSimilarityFunctions().map(ignore -> new VectorScorerFactoryImpl()).orElse(null);

    private VectorScorerFactoryImpl() {
    }

    @Override
    public Optional<RandomVectorScorerSupplier> getInt7SQVectorScorerSupplier(VectorSimilarityType similarityType, IndexInput input, RandomAccessQuantizedByteVectorValues values, float scoreCorrectionConstant) {
        if (!((input = FilterIndexInput.unwrapOnlyTest((IndexInput)input)) instanceof MemorySegmentAccessInput)) {
            return Optional.empty();
        }
        MemorySegmentAccessInput msInput = (MemorySegmentAccessInput)input;
        VectorScorerFactoryImpl.checkInvariants(values.size(), values.dimension(), input);
        return switch (similarityType) {
            default -> throw new MatchException(null, null);
            case VectorSimilarityType.COSINE, VectorSimilarityType.DOT_PRODUCT -> Optional.of(new Int7SQVectorScorerSupplier.DotProductSupplier(msInput, values, scoreCorrectionConstant));
            case VectorSimilarityType.EUCLIDEAN -> Optional.of(new Int7SQVectorScorerSupplier.EuclideanSupplier(msInput, values, scoreCorrectionConstant));
            case VectorSimilarityType.MAXIMUM_INNER_PRODUCT -> Optional.of(new Int7SQVectorScorerSupplier.MaxInnerProductSupplier(msInput, values, scoreCorrectionConstant));
        };
    }

    @Override
    public Optional<RandomVectorScorer> getInt7SQVectorScorer(VectorSimilarityFunction sim, RandomAccessQuantizedByteVectorValues values, float[] queryVector) {
        return Int7SQVectorScorer.create(sim, values, queryVector);
    }

    static void checkInvariants(int maxOrd, int vectorByteLength, IndexInput input) {
        if (input.length() < (long)vectorByteLength * (long)maxOrd) {
            throw new IllegalArgumentException("input length is less than expected vector data");
        }
    }
}

