/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.response;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;

public class VoyageAIRerankResponseEntity {
    private static final Logger logger = LogManager.getLogger(VoyageAIRerankResponseEntity.class);

    public static InferenceServiceResults fromResponse(HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            RerankResult rerankResult = (RerankResult)RerankResult.PARSER.apply(jsonParser, null);
            RankedDocsResults rankedDocsResults = new RankedDocsResults(rerankResult.entries.stream().map(RerankResultEntry::toRankedDoc).toList());
            return rankedDocsResults;
        }
    }

    private VoyageAIRerankResponseEntity() {
    }

    record RerankResult(List<RerankResultEntry> entries) {
        public static final ConstructingObjectParser<RerankResult, Void> PARSER = new ConstructingObjectParser(RerankResult.class.getSimpleName(), true, args -> new RerankResult((List)args[0]));

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> RerankResultEntry.PARSER.apply(arg_0, arg_1), new ParseField("data", new String[0]));
        }
    }

    record RerankResultEntry(Float relevanceScore, Integer index, @Nullable String document) {
        public static final ConstructingObjectParser<RerankResultEntry, Void> PARSER = new ConstructingObjectParser(RerankResultEntry.class.getSimpleName(), args -> new RerankResultEntry((Float)args[0], (Integer)args[1], (String)args[2]));

        public RankedDocsResults.RankedDoc toRankedDoc() {
            return new RankedDocsResults.RankedDoc(this.index.intValue(), this.relevanceScore.floatValue(), this.document);
        }

        static {
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("relevance_score", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("document", new String[0]));
        }
    }
}

