/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.response;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingBitResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingType;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIEmbeddingsRequest;

public class VoyageAIEmbeddingsResponseEntity {
    private static final String VALID_EMBEDDING_TYPES_STRING = VoyageAIEmbeddingsResponseEntity.supportedEmbeddingTypes();

    private static String supportedEmbeddingTypes() {
        Object[] validTypes = new String[]{VoyageAIEmbeddingType.toLowerCase(VoyageAIEmbeddingType.FLOAT), VoyageAIEmbeddingType.toLowerCase(VoyageAIEmbeddingType.INT8), VoyageAIEmbeddingType.toLowerCase(VoyageAIEmbeddingType.BIT)};
        Arrays.sort(validTypes);
        return String.join((CharSequence)", ", (CharSequence[])validTypes);
    }

    public static InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        VoyageAIEmbeddingType embeddingType = ((VoyageAIEmbeddingsRequest)request).getServiceSettings().getEmbeddingType();
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            if (embeddingType == null || embeddingType == VoyageAIEmbeddingType.FLOAT) {
                EmbeddingFloatResult embeddingResult = (EmbeddingFloatResult)EmbeddingFloatResult.PARSER.apply(jsonParser, null);
                List<TextEmbeddingFloatResults.Embedding> embeddingList = embeddingResult.entries.stream().map(EmbeddingFloatResultEntry::toInferenceFloatEmbedding).toList();
                TextEmbeddingFloatResults textEmbeddingFloatResults = new TextEmbeddingFloatResults(embeddingList);
                return textEmbeddingFloatResults;
            }
            if (embeddingType == VoyageAIEmbeddingType.INT8) {
                EmbeddingInt8Result embeddingResult = (EmbeddingInt8Result)EmbeddingInt8Result.PARSER.apply(jsonParser, null);
                List<TextEmbeddingByteResults.Embedding> embeddingList = embeddingResult.entries.stream().map(EmbeddingInt8ResultEntry::toInferenceByteEmbedding).toList();
                TextEmbeddingByteResults textEmbeddingByteResults = new TextEmbeddingByteResults(embeddingList);
                return textEmbeddingByteResults;
            }
            if (embeddingType == VoyageAIEmbeddingType.BIT || embeddingType == VoyageAIEmbeddingType.BINARY) {
                EmbeddingInt8Result embeddingResult = (EmbeddingInt8Result)EmbeddingInt8Result.PARSER.apply(jsonParser, null);
                List<TextEmbeddingByteResults.Embedding> embeddingList = embeddingResult.entries.stream().map(EmbeddingInt8ResultEntry::toInferenceByteEmbedding).toList();
                TextEmbeddingBitResults textEmbeddingBitResults = new TextEmbeddingBitResults(embeddingList);
                return textEmbeddingBitResults;
            }
            throw new IllegalArgumentException("Illegal embedding_type value: " + String.valueOf((Object)embeddingType) + ". Supported types are: " + VALID_EMBEDDING_TYPES_STRING);
        }
    }

    private VoyageAIEmbeddingsResponseEntity() {
    }

    record EmbeddingFloatResult(List<EmbeddingFloatResultEntry> entries) {
        public static final ConstructingObjectParser<EmbeddingFloatResult, Void> PARSER = new ConstructingObjectParser(EmbeddingFloatResult.class.getSimpleName(), true, args -> new EmbeddingFloatResult((List)args[0]));

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> EmbeddingFloatResultEntry.PARSER.apply(arg_0, arg_1), new ParseField("data", new String[0]));
        }
    }

    record EmbeddingInt8Result(List<EmbeddingInt8ResultEntry> entries) {
        public static final ConstructingObjectParser<EmbeddingInt8Result, Void> PARSER = new ConstructingObjectParser(EmbeddingInt8Result.class.getSimpleName(), true, args -> new EmbeddingInt8Result((List)args[0]));

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> EmbeddingInt8ResultEntry.PARSER.apply(arg_0, arg_1), new ParseField("data", new String[0]));
        }
    }

    record EmbeddingFloatResultEntry(Integer index, List<Float> embedding) {
        public static final ConstructingObjectParser<EmbeddingFloatResultEntry, Void> PARSER = new ConstructingObjectParser(EmbeddingFloatResultEntry.class.getSimpleName(), true, args -> new EmbeddingFloatResultEntry((Integer)args[0], (List)args[1]));

        public TextEmbeddingFloatResults.Embedding toInferenceFloatEmbedding() {
            return TextEmbeddingFloatResults.Embedding.of(this.embedding);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
            PARSER.declareFloatArray(ConstructingObjectParser.constructorArg(), new ParseField("embedding", new String[0]));
        }
    }

    record EmbeddingInt8ResultEntry(Integer index, List<Integer> embedding) {
        public static final ConstructingObjectParser<EmbeddingInt8ResultEntry, Void> PARSER = new ConstructingObjectParser(EmbeddingInt8ResultEntry.class.getSimpleName(), true, args -> new EmbeddingInt8ResultEntry((Integer)args[0], (List)args[1]));

        private static void checkByteBounds(Integer value) {
            if (value < -128 || value > 127) {
                throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
            }
        }

        public TextEmbeddingByteResults.Embedding toInferenceByteEmbedding() {
            this.embedding.forEach(EmbeddingInt8ResultEntry::checkByteBounds);
            return TextEmbeddingByteResults.Embedding.of(this.embedding.stream().map(Integer::byteValue).toList());
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
            PARSER.declareIntArray(ConstructingObjectParser.constructorArg(), new ParseField("embedding", new String[0]));
        }
    }
}

