/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.validation;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.validation.ServiceIntegrationValidator;
import org.elasticsearch.rest.RestStatus;

public class SimpleServiceIntegrationValidator
implements ServiceIntegrationValidator {
    private static final List<String> TEST_INPUT = List.of("how big");
    private static final String QUERY = "test query";

    public void validate(InferenceService service, Model model, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        service.infer(model, model.getTaskType().equals((Object)TaskType.RERANK) ? QUERY : null, null, null, TEST_INPUT, false, Map.of(), InputType.INTERNAL_INGEST, timeout, ActionListener.wrap(r -> {
            if (r != null) {
                listener.onResponse(r);
            } else {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Could not complete inference endpoint creation as validation call to service returned null response.", RestStatus.BAD_REQUEST, new Object[0])));
            }
        }, e -> listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Could not complete inference endpoint creation as validation call to service threw an exception.", RestStatus.BAD_REQUEST, (Throwable)e, new Object[0])))));
    }
}

