/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.mistral.MistralModel;
import org.elasticsearch.xpack.inference.services.mistral.action.MistralActionVisitor;
import org.elasticsearch.xpack.inference.services.mistral.completion.MistralChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class MistralChatCompletionModel
extends MistralModel {
    public MistralChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, MistralChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    public static MistralChatCompletionModel of(MistralChatCompletionModel model, UnifiedCompletionRequest request) {
        if (request.model() == null) {
            return model;
        }
        MistralChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        MistralChatCompletionServiceSettings overriddenServiceSettings = new MistralChatCompletionServiceSettings(request.model(), originalModelServiceSettings.rateLimitSettings());
        return new MistralChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    public MistralChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, MistralChatCompletionServiceSettings serviceSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)new EmptyTaskSettings()), new ModelSecrets((SecretSettings)secrets));
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    private void setPropertiesFromServiceSettings(MistralChatCompletionServiceSettings serviceSettings) {
        this.model = serviceSettings.modelId();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
        this.setEndpointUrl();
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.model, this.getSecretSettings().apiKey());
    }

    private void setEndpointUrl() {
        try {
            this.uri = new URI("https://api.mistral.ai/v1/chat/completions");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public MistralChatCompletionServiceSettings getServiceSettings() {
        return (MistralChatCompletionServiceSettings)super.getServiceSettings();
    }

    public ExecutableAction accept(MistralActionVisitor creator) {
        return creator.create(this);
    }
}

