/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class GoogleVertexAiRerankResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Google Vertex AI rerank response";
    private static final String INVALID_ID_FIELD_FORMAT_TEMPLATE = "Expected numeric value for record ID field in Google Vertex AI rerank response but received [%s]";

    public static RankedDocsResults fromResponse(HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "records", FAILED_TO_FIND_FIELD_TEMPLATE);
            List<RankedDocsResults.RankedDoc> rankedDocs = GoogleVertexAiRerankResponseEntity.doParse(jsonParser);
            RankedDocsResults rankedDocsResults = new RankedDocsResults(rankedDocs);
            return rankedDocsResults;
        }
    }

    private static List<RankedDocsResults.RankedDoc> doParse(XContentParser parser) throws IOException {
        return XContentParserUtils.parseList((XContentParser)parser, (listParser, index) -> {
            RankedDoc parsedRankedDoc = RankedDoc.parse(parser);
            if (parsedRankedDoc.score == null) {
                throw new IllegalStateException(Strings.format((String)FAILED_TO_FIND_FIELD_TEMPLATE, (Object[])new Object[]{RankedDoc.SCORE.getPreferredName()}));
            }
            if (parsedRankedDoc.id == null) {
                throw new IllegalStateException(Strings.format((String)FAILED_TO_FIND_FIELD_TEMPLATE, (Object[])new Object[]{RankedDoc.ID.getPreferredName()}));
            }
            try {
                return new RankedDocsResults.RankedDoc(Integer.parseInt(parsedRankedDoc.id), parsedRankedDoc.score.floatValue(), parsedRankedDoc.content);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(Strings.format((String)INVALID_ID_FIELD_FORMAT_TEMPLATE, (Object[])new Object[]{parsedRankedDoc.id}));
            }
        });
    }

    private record RankedDoc(@Nullable Float score, @Nullable String content, @Nullable String id) {
        private static final ParseField CONTENT = new ParseField("content", new String[0]);
        private static final ParseField SCORE = new ParseField("score", new String[0]);
        private static final ParseField ID = new ParseField("id", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("google_vertex_ai_rerank_response", true, Builder::new);

        public static RankedDoc parse(XContentParser parser) {
            Builder builder = (Builder)PARSER.apply(parser, null);
            return builder.build();
        }

        static {
            PARSER.declareString(Builder::setContent, CONTENT);
            PARSER.declareFloat(Builder::setScore, SCORE);
            PARSER.declareString(Builder::setId, ID);
        }

        private static final class Builder {
            private String content;
            private Float score;
            private String id;

            private Builder() {
            }

            public Builder setScore(Float score) {
                this.score = score;
                return this;
            }

            public Builder setContent(String content) {
                this.content = content;
                return this;
            }

            public Builder setId(String id) {
                this.id = id;
                return this;
            }

            public RankedDoc build() {
                return new RankedDoc(this.score, this.content, this.id);
            }
        }
    }
}

