/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.action.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleDiscoveryEngineRateLimitServiceSettings;

public class GoogleVertexAiChatCompletionModel
extends GoogleVertexAiModel {
    private final URI streamingURI;

    public GoogleVertexAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, GoogleVertexAiChatCompletionServiceSettings.fromMap(serviceSettings, context), new EmptyTaskSettings(), GoogleVertexAiSecretSettings.fromMap(secrets));
    }

    GoogleVertexAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, GoogleVertexAiChatCompletionServiceSettings serviceSettings, EmptyTaskSettings taskSettings, @Nullable GoogleVertexAiSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings);
        try {
            this.streamingURI = GoogleVertexAiChatCompletionModel.buildUriStreaming(serviceSettings.location(), serviceSettings.projectId(), serviceSettings.modelId());
            this.nonStreamingUri = GoogleVertexAiChatCompletionModel.buildUriNonStreaming(serviceSettings.location(), serviceSettings.projectId(), serviceSettings.modelId());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static GoogleVertexAiChatCompletionModel of(GoogleVertexAiChatCompletionModel model, UnifiedCompletionRequest request) {
        GoogleVertexAiChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        GoogleVertexAiChatCompletionServiceSettings newServiceSettings = new GoogleVertexAiChatCompletionServiceSettings(originalModelServiceSettings.projectId(), originalModelServiceSettings.location(), Objects.requireNonNullElse(request.model(), originalModelServiceSettings.modelId()), originalModelServiceSettings.rateLimitSettings());
        return new GoogleVertexAiChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), newServiceSettings, model.getTaskSettings(), model.getSecretSettings());
    }

    @Override
    public ExecutableAction accept(GoogleVertexAiActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this, taskSettings);
    }

    @Override
    public GoogleDiscoveryEngineRateLimitServiceSettings rateLimitServiceSettings() {
        return (GoogleDiscoveryEngineRateLimitServiceSettings)super.rateLimitServiceSettings();
    }

    public GoogleVertexAiChatCompletionServiceSettings getServiceSettings() {
        return (GoogleVertexAiChatCompletionServiceSettings)super.getServiceSettings();
    }

    public EmptyTaskSettings getTaskSettings() {
        return (EmptyTaskSettings)super.getTaskSettings();
    }

    public GoogleVertexAiSecretSettings getSecretSettings() {
        return (GoogleVertexAiSecretSettings)super.getSecretSettings();
    }

    public URI streamingURI() {
        return this.streamingURI;
    }

    public static URI buildUriNonStreaming(String location, String projectId, String model) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(Strings.format((String)"%s%s", (Object[])new Object[]{location, "-aiplatform.googleapis.com"})).setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "publishers", "google", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{model, "generateContent"})}).build();
    }

    public static URI buildUriStreaming(String location, String projectId, String model) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(Strings.format((String)"%s%s", (Object[])new Object[]{location, "-aiplatform.googleapis.com"})).setPathSegments(new String[]{"v1", "projects", projectId, "locations", "global", "publishers", "google", "models", Strings.format((String)"%s:%s", (Object[])new Object[]{model, "streamGenerateContent"})}).setCustomQuery("alt=sse").build();
    }

    @Override
    public int rateLimitGroupingHash() {
        String projectId = this.getServiceSettings().projectId();
        String location = this.getServiceSettings().location();
        String modelId = this.getServiceSettings().modelId();
        return Objects.hash(projectId, location, modelId, "generateContent", "streamGenerateContent");
    }
}

