/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiResponseHandler;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiUnifiedStreamingProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.response.GoogleVertexAiCompletionResponseEntity;

public class GoogleVertexAiUnifiedChatCompletionResponseHandler
extends GoogleVertexAiResponseHandler {
    private static final String ERROR_FIELD = "error";
    private static final String ERROR_CODE_FIELD = "code";
    private static final String ERROR_MESSAGE_FIELD = "message";
    private static final String ERROR_STATUS_FIELD = "status";

    public GoogleVertexAiUnifiedChatCompletionResponseHandler(String requestType) {
        super(requestType, GoogleVertexAiCompletionResponseEntity::fromResponse, GoogleVertexAiErrorResponse::fromResponse, true);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        assert (request.isStreaming()) : "GoogleVertexAiUnifiedChatCompletionResponseHandler only supports streaming requests";
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        GoogleVertexAiUnifiedStreamingProcessor googleVertexAiProcessor = new GoogleVertexAiUnifiedStreamingProcessor((m, e) -> GoogleVertexAiUnifiedChatCompletionResponseHandler.buildMidStreamError(request, m, e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(googleVertexAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)googleVertexAiProcessor);
    }

    @Override
    protected Exception buildError(String message, Request request, HttpResult result, ErrorResponse errorResponse) {
        UnifiedChatCompletionException unifiedChatCompletionException;
        assert (request.isStreaming()) : "Only streaming requests support this format";
        int responseStatusCode = result.response().getStatusLine().getStatusCode();
        String errorMessage = this.errorMessage(message, request, result, errorResponse, responseStatusCode);
        RestStatus restStatus = GoogleVertexAiUnifiedChatCompletionResponseHandler.toRestStatus(responseStatusCode);
        if (errorResponse instanceof GoogleVertexAiErrorResponse) {
            GoogleVertexAiErrorResponse vertexAIErrorResponse = (GoogleVertexAiErrorResponse)errorResponse;
            unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, vertexAIErrorResponse.status(), String.valueOf(vertexAIErrorResponse.code()), null);
        } else {
            unifiedChatCompletionException = new UnifiedChatCompletionException(restStatus, errorMessage, errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown", restStatus.name().toLowerCase(Locale.ROOT));
        }
        return unifiedChatCompletionException;
    }

    private static Exception buildMidStreamError(Request request, String message, Exception e) {
        ErrorResponse errorResponse = GoogleVertexAiErrorResponse.fromString(message);
        if (errorResponse instanceof GoogleVertexAiErrorResponse) {
            GoogleVertexAiErrorResponse gver = (GoogleVertexAiErrorResponse)errorResponse;
            return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]. Error message: [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId(), errorResponse.getErrorMessage()}), gver.status(), String.valueOf(gver.code()), null);
        }
        if (e != null) {
            return UnifiedChatCompletionException.fromThrowable((Throwable)e);
        }
        return new UnifiedChatCompletionException(RestStatus.INTERNAL_SERVER_ERROR, Strings.format((String)"%s for request from inference entity id [%s]", (Object[])new Object[]{"Received an error response", request.getInferenceEntityId()}), errorResponse != null ? errorResponse.getClass().getSimpleName() : "unknown", "stream_error");
    }

    public static class GoogleVertexAiErrorResponse
    extends ErrorResponse {
        private static final Logger logger = LogManager.getLogger(GoogleVertexAiErrorResponse.class);
        private static final ConstructingObjectParser<Optional<ErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("google_vertex_ai_error_wrapper", true, args -> Optional.ofNullable((GoogleVertexAiErrorResponse)args[0]));
        private static final ConstructingObjectParser<GoogleVertexAiErrorResponse, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("google_vertex_ai_error_body", true, args -> new GoogleVertexAiErrorResponse((Integer)args[0], (String)args[1], (String)args[2]));
        private final int code;
        @Nullable
        private final String status;

        public static ErrorResponse fromResponse(HttpResult response) {
            ErrorResponse errorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());
                try {
                    errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        String resultAsString = new String(response.body(), StandardCharsets.UTF_8);
                        return new ErrorResponse(org.elasticsearch.common.Strings.format((String)"Unable to parse the Google Vertex AI error, response body: [%s]", (Object[])new Object[]{resultAsString}));
                    }
                }
                parser.close();
            }
            return errorResponse;
        }

        static ErrorResponse fromString(String response) {
            ErrorResponse errorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
                try {
                    errorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(ErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return new ErrorResponse(org.elasticsearch.common.Strings.format((String)"Unable to parse the Google Vertex AI error, response body: [%s]", (Object[])new Object[]{response}));
                    }
                }
                parser.close();
            }
            return errorResponse;
        }

        GoogleVertexAiErrorResponse(Integer code, String errorMessage, @Nullable String status) {
            super(Objects.requireNonNull(errorMessage));
            this.code = code == null ? 0 : code;
            this.status = status;
        }

        public int code() {
            return this.code;
        }

        @Nullable
        public String status() {
            return this.status != null ? this.status : "google_vertex_ai_error";
        }

        static {
            ERROR_BODY_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_CODE_FIELD, new String[0]));
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_MESSAGE_FIELD, new String[0]));
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_STATUS_FIELD, new String[0]));
            ERROR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_FIELD, new String[0]));
        }
    }
}

