/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;
import org.elasticsearch.xpack.inference.telemetry.TraceContextHandler;

public class ElasticInferenceServiceAuthorizationRequest
extends ElasticInferenceServiceRequest {
    private final URI uri;
    private final TraceContextHandler traceContextHandler;

    public ElasticInferenceServiceAuthorizationRequest(String url, TraceContext traceContext, ElasticInferenceServiceRequestMetadata requestMetadata) {
        super(requestMetadata);
        this.uri = this.createUri(Objects.requireNonNull(url));
        this.traceContextHandler = new TraceContextHandler(traceContext);
    }

    private URI createUri(String url) throws ElasticsearchStatusException {
        try {
            return new URI(url + "/api/v1/authorizations");
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException("Failed to create URI for service [elastic]: " + e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public HttpRequestBase createHttpRequestBase() {
        HttpGet httpGet = new HttpGet(this.uri);
        this.traceContextHandler.propagateTraceContext((HttpRequestBase)httpGet);
        return httpGet;
    }

    public TraceContext getTraceContext() {
        return this.traceContextHandler.traceContext();
    }

    @Override
    public String getInferenceEntityId() {
        return "authorization_request";
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

