/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceExecutableActionModel;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.action.ElasticInferenceServiceActionVisitor;

public class ElasticInferenceServiceSparseEmbeddingsModel
extends ElasticInferenceServiceExecutableActionModel {
    private final URI uri = this.createUri();

    public ElasticInferenceServiceSparseEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, Map<String, Object> secrets, ElasticInferenceServiceComponents elasticInferenceServiceComponents, ConfigurationParseContext context, ChunkingSettings chunkingSettings) {
        this(inferenceEntityId, taskType, service, ElasticInferenceServiceSparseEmbeddingsServiceSettings.fromMap(serviceSettings, context), (TaskSettings)EmptyTaskSettings.INSTANCE, (SecretSettings)EmptySecretSettings.INSTANCE, elasticInferenceServiceComponents, chunkingSettings);
    }

    public ElasticInferenceServiceSparseEmbeddingsModel(ElasticInferenceServiceSparseEmbeddingsModel model, ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings) {
        super(model, (ServiceSettings)serviceSettings);
    }

    public ElasticInferenceServiceSparseEmbeddingsModel(String inferenceEntityId, TaskType taskType, String service, ElasticInferenceServiceSparseEmbeddingsServiceSettings serviceSettings, @Nullable TaskSettings taskSettings, @Nullable SecretSettings secretSettings, ElasticInferenceServiceComponents elasticInferenceServiceComponents, ChunkingSettings chunkingSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, taskSettings, chunkingSettings), new ModelSecrets(secretSettings), serviceSettings, elasticInferenceServiceComponents);
    }

    @Override
    public ExecutableAction accept(ElasticInferenceServiceActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this);
    }

    public ElasticInferenceServiceSparseEmbeddingsServiceSettings getServiceSettings() {
        return (ElasticInferenceServiceSparseEmbeddingsServiceSettings)super.getServiceSettings();
    }

    public URI uri() {
        return this.uri;
    }

    private URI createUri() throws ElasticsearchStatusException {
        try {
            return new URI(this.elasticInferenceServiceComponents().elasticInferenceServiceUrl() + "/api/v1/embed/text/sparse");
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException("Failed to create URI for service [" + this.getConfigurations().getService() + "] with taskType [" + String.valueOf(this.getTaskType()) + "]: " + e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }
}

