/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.BaseResponseEntity;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.request.AzureAiStudioChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.openai.response.OpenAiChatCompletionResponseEntity;

public class AzureAiStudioChatCompletionResponseEntity
extends BaseResponseEntity {
    @Override
    protected InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        if (request instanceof AzureAiStudioChatCompletionRequest) {
            AzureAiStudioChatCompletionRequest asChatCompletionRequest = (AzureAiStudioChatCompletionRequest)request;
            if (asChatCompletionRequest.isRealtimeEndpoint()) {
                return this.parseRealtimeEndpointResponse(response);
            }
            return OpenAiChatCompletionResponseEntity.fromResponse(request, response);
        }
        return null;
    }

    private ChatCompletionResults parseRealtimeEndpointResponse(HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            while (token != null && token != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) {
                    token = jsonParser.nextToken();
                    continue;
                }
                String currentName = jsonParser.currentName();
                if (currentName == null || !currentName.equalsIgnoreCase("output")) {
                    token = jsonParser.nextToken();
                    continue;
                }
                token = jsonParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_STRING, (XContentParser.Token)token, (XContentParser)jsonParser);
                String content = jsonParser.text();
                ChatCompletionResults chatCompletionResults = new ChatCompletionResults(List.of(new ChatCompletionResults.Result(content)));
                return chatCompletionResults;
            }
            throw new IllegalStateException("Reached an invalid state while parsing the Azure AI Studio completion response");
        }
    }
}

