/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.embeddings;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsRequestTaskSettings;

public class AzureAiStudioEmbeddingsTaskSettings
implements TaskSettings {
    public static final String NAME = "azure_ai_studio_embeddings_task_settings";
    private final String user;

    public static AzureAiStudioEmbeddingsTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        String user = ServiceUtils.extractOptionalString(map, "user", "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioEmbeddingsTaskSettings(user);
    }

    public static AzureAiStudioEmbeddingsTaskSettings of(AzureAiStudioEmbeddingsTaskSettings originalSettings, AzureAiStudioEmbeddingsRequestTaskSettings requestSettings) {
        String userToUse = requestSettings.user() == null ? originalSettings.user : requestSettings.user();
        return new AzureAiStudioEmbeddingsTaskSettings(userToUse);
    }

    public AzureAiStudioEmbeddingsTaskSettings(@Nullable String user) {
        this.user = user;
    }

    public AzureAiStudioEmbeddingsTaskSettings(StreamInput in) throws IOException {
        this.user = in.readOptionalString();
    }

    public String user() {
        return this.user;
    }

    public boolean isEmpty() {
        return this.user == null || this.user.isEmpty();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.user);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.user != null) {
            builder.field("user", this.user);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAiStudioEmbeddingsTaskSettings that = (AzureAiStudioEmbeddingsTaskSettings)o;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hashCode(this.user);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        AzureAiStudioEmbeddingsRequestTaskSettings requestSettings = AzureAiStudioEmbeddingsRequestTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return AzureAiStudioEmbeddingsTaskSettings.of(this, requestSettings);
    }
}

