/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio;

import java.util.List;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;

public final class AzureAiStudioProviderCapabilities {
    public static final List<AzureAiStudioProvider> embeddingProviders = List.of(AzureAiStudioProvider.OPENAI, AzureAiStudioProvider.COHERE);
    public static final List<AzureAiStudioProvider> chatCompletionProviders = List.of(AzureAiStudioProvider.values());
    public static final List<AzureAiStudioProvider> tokenEmbeddingsProviders = List.of(AzureAiStudioProvider.OPENAI, AzureAiStudioProvider.COHERE);
    public static final List<AzureAiStudioProvider> realtimeEmbeddingsProviders = List.of();
    public static final List<AzureAiStudioProvider> tokenChatCompletionProviders = List.of(AzureAiStudioProvider.OPENAI, AzureAiStudioProvider.META, AzureAiStudioProvider.COHERE);
    public static final List<AzureAiStudioProvider> realtimeChatCompletionProviders = List.of(AzureAiStudioProvider.MISTRAL, AzureAiStudioProvider.META, AzureAiStudioProvider.MICROSOFT_PHI, AzureAiStudioProvider.DATABRICKS);

    public static boolean providerAllowsTaskType(AzureAiStudioProvider provider, TaskType taskType) {
        switch (taskType) {
            case COMPLETION: {
                return chatCompletionProviders.contains((Object)provider);
            }
            case TEXT_EMBEDDING: {
                return embeddingProviders.contains((Object)provider);
            }
        }
        return false;
    }

    public static boolean providerAllowsEndpointTypeForTask(AzureAiStudioProvider provider, TaskType taskType, AzureAiStudioEndpointType endpointType) {
        switch (taskType) {
            case COMPLETION: {
                return endpointType == AzureAiStudioEndpointType.TOKEN ? tokenChatCompletionProviders.contains((Object)provider) : realtimeChatCompletionProviders.contains((Object)provider);
            }
            case TEXT_EMBEDDING: {
                return endpointType == AzureAiStudioEndpointType.TOKEN ? tokenEmbeddingsProviders.contains((Object)provider) : realtimeEmbeddingsProviders.contains((Object)provider);
            }
        }
        return false;
    }
}

