/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.completion;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record AnthropicChatCompletionRequestTaskSettings(@Nullable Integer maxTokens, @Nullable Double temperature, @Nullable Double topP, @Nullable Integer topK) {
    public static final AnthropicChatCompletionRequestTaskSettings EMPTY_SETTINGS = new AnthropicChatCompletionRequestTaskSettings(null, null, null, null);

    public static AnthropicChatCompletionRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        Integer maxTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_tokens", "service_settings", validationException);
        Double temperature = ServiceUtils.removeAsType(map, "temperature", Double.class);
        Double topP = ServiceUtils.removeAsType(map, "top_p", Double.class);
        Integer topK = ServiceUtils.removeAsType(map, "top_k", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AnthropicChatCompletionRequestTaskSettings(maxTokens, temperature, topP, topK);
    }
}

