/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic;

import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicAccount;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicModel;

abstract class AnthropicRequestManager
extends BaseRequestManager {
    protected AnthropicRequestManager(ThreadPool threadPool, AnthropicModel model) {
        super(threadPool, model.getInferenceEntityId(), RateLimitGrouping.of(model), model.rateLimitServiceSettings().rateLimitSettings());
    }

    record RateLimitGrouping(int accountHash, int modelIdHash) {
        public static RateLimitGrouping of(AnthropicModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(AnthropicAccount.of(model).hashCode(), model.rateLimitServiceSettings().modelId().hashCode());
        }
    }
}

