/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.client;

import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockBaseClient;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockClientCache;
import org.elasticsearch.xpack.inference.services.amazonbedrock.client.AmazonBedrockExecutor;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.AmazonBedrockResponseHandler;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.embeddings.AmazonBedrockEmbeddingsResponseListener;

public class AmazonBedrockEmbeddingsExecutor
extends AmazonBedrockExecutor {
    private final AmazonBedrockEmbeddingsRequest embeddingsRequest;

    protected AmazonBedrockEmbeddingsExecutor(AmazonBedrockEmbeddingsRequest request, AmazonBedrockResponseHandler responseHandler, Logger logger, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> inferenceResultsListener, AmazonBedrockClientCache clientCache) {
        super(request, responseHandler, logger, hasRequestCompletedFunction, inferenceResultsListener, clientCache);
        this.embeddingsRequest = request;
    }

    @Override
    protected void executeClientRequest(AmazonBedrockBaseClient awsBedrockClient) {
        AmazonBedrockEmbeddingsResponseListener embeddingsResponseListener = new AmazonBedrockEmbeddingsResponseListener(this.embeddingsRequest, this.responseHandler, (ActionListener<InferenceServiceResults>)this.inferenceResultsListener);
        this.embeddingsRequest.executeEmbeddingsRequest(awsBedrockClient, embeddingsResponseListener);
    }
}

