/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;

public class GenericRequestManager<T extends InferenceInputs>
extends BaseRequestManager {
    private static final Logger logger = LogManager.getLogger(GenericRequestManager.class);
    protected final ResponseHandler responseHandler;
    protected final Function<T, Request> requestCreator;
    protected final Class<T> inputType;

    public GenericRequestManager(ThreadPool threadPool, RateLimitGroupingModel rateLimitGroupingModel, ResponseHandler responseHandler, Function<T, Request> requestCreator, Class<T> inputType) {
        super(threadPool, rateLimitGroupingModel);
        this.responseHandler = Objects.requireNonNull(responseHandler);
        this.requestCreator = Objects.requireNonNull(requestCreator);
        this.inputType = Objects.requireNonNull(inputType);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        Request request = this.requestCreator.apply(inferenceInputs.castTo(this.inputType));
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, this.responseHandler, hasRequestCompletedFunction, listener));
    }
}

