/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;

public class EmbeddingsInput
extends InferenceInputs {
    private final Supplier<List<String>> inputListSupplier;
    private final InputType inputType;
    private final AtomicBoolean supplierInvoked = new AtomicBoolean();

    public EmbeddingsInput(List<String> input, @Nullable InputType inputType) {
        this(() -> input, inputType, false);
    }

    public EmbeddingsInput(List<String> input, @Nullable InputType inputType, boolean stream) {
        this(() -> input, inputType, stream);
    }

    public EmbeddingsInput(Supplier<List<String>> inputSupplier, @Nullable InputType inputType) {
        this(inputSupplier, inputType, false);
    }

    private EmbeddingsInput(Supplier<List<String>> inputSupplier, @Nullable InputType inputType, boolean stream) {
        super(stream);
        this.inputListSupplier = Objects.requireNonNull(inputSupplier);
        this.inputType = inputType;
    }

    public List<String> getInputs() {
        assert (this.supplierInvoked.compareAndSet(false, true)) : "EmbeddingsInput supplier invoked twice";
        return this.inputListSupplier.get();
    }

    public InputType getInputType() {
        return this.inputType;
    }

    @Override
    public boolean isSingleInput() {
        return false;
    }
}

