/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.IOException;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.RequestBasedTaskRunner;
import org.elasticsearch.xpack.inference.external.http.StreamingHttpResult;

class StreamingHttpResultPublisher
implements HttpAsyncResponseConsumer<Void> {
    private final ActionListener<StreamingHttpResult> listener;
    private final AtomicBoolean listenerCalled = new AtomicBoolean(false);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean subscriptionCanceled = new AtomicBoolean(false);
    private final SimpleInputBuffer inputBuffer = new SimpleInputBuffer(4096);
    private final DataPublisher publisher;
    private final ApacheClientBackpressure backpressure;
    private volatile Exception exception;

    StreamingHttpResultPublisher(ThreadPool threadPool, HttpSettings settings, ActionListener<StreamingHttpResult> listener) {
        this.listener = ActionListener.notifyOnce(Objects.requireNonNull(listener));
        this.publisher = new DataPublisher(threadPool);
        this.backpressure = new ApacheClientBackpressure(Objects.requireNonNull(settings));
    }

    public void responseReceived(HttpResponse httpResponse) {
        if (this.listenerCalled.compareAndSet(false, true)) {
            this.listener.onResponse((Object)new StreamingHttpResult(httpResponse, this.publisher));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent(ContentDecoder contentDecoder, IOControl ioControl) throws IOException {
        if (this.subscriptionCanceled.get()) {
            ioControl.shutdown();
            return;
        }
        try {
            int consumed = this.inputBuffer.consumeContent(contentDecoder);
            if (consumed > 0) {
                byte[] allBytes = new byte[consumed];
                this.inputBuffer.read(allBytes);
                this.backpressure.addBytesAndMaybePause(consumed, ioControl);
                this.publisher.onNext(allBytes);
            }
        }
        catch (Exception e) {
            this.exception = e;
            this.publisher.onError(e);
        }
        finally {
            this.inputBuffer.reset();
        }
    }

    public void responseCompleted(HttpContext httpContext) {
    }

    public void failed(Exception e) {
        if (this.isDone.compareAndSet(false, true)) {
            if (this.listenerCalled.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            } else {
                this.exception = e;
                this.publisher.onError(e);
            }
        }
    }

    public void close() {
        if (this.isDone.compareAndSet(false, true)) {
            this.publisher.onComplete();
        }
    }

    public boolean cancel() {
        this.close();
        return true;
    }

    public Exception getException() {
        return this.exception;
    }

    public Void getResult() {
        return null;
    }

    public boolean isDone() {
        return this.isDone.get();
    }

    private class DataPublisher
    implements Flow.Processor<byte[], byte[]> {
        private final RequestBasedTaskRunner taskRunner;
        private final Deque<byte[]> contentQueue = new ConcurrentLinkedDeque<byte[]>();
        private final AtomicLong pendingRequests = new AtomicLong(0L);
        private volatile Exception pendingError = null;
        private volatile boolean completed = false;
        private volatile Flow.Subscriber<? super byte[]> downstream;

        private DataPublisher(ThreadPool threadPool) {
            this.taskRunner = new RequestBasedTaskRunner(this::sendToSubscriber, threadPool, "inference_utility");
        }

        private void sendToSubscriber() {
            byte[] nextBytes;
            if (this.downstream == null) {
                return;
            }
            if (this.pendingRequests.get() > 0L && this.pendingError != null) {
                this.pendingRequests.decrementAndGet();
                this.downstream.onError(this.pendingError);
                return;
            }
            while (this.pendingRequests.get() > 0L && (nextBytes = this.contentQueue.poll()) != null) {
                this.pendingRequests.decrementAndGet();
                StreamingHttpResultPublisher.this.backpressure.subtractBytesAndMaybeUnpause(nextBytes.length);
                this.downstream.onNext((byte[])nextBytes);
            }
            if (this.pendingRequests.get() > 0L && this.contentQueue.isEmpty() && this.completed) {
                this.pendingRequests.decrementAndGet();
                this.downstream.onComplete();
            }
        }

        @Override
        public void subscribe(final Flow.Subscriber<? super byte[]> subscriber) {
            if (this.downstream != null) {
                subscriber.onError(new IllegalStateException("Only one subscriber is allowed for this Publisher."));
                return;
            }
            this.downstream = subscriber;
            this.downstream.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long n) {
                    if (n > 0L) {
                        DataPublisher.this.pendingRequests.addAndGet(n);
                        DataPublisher.this.taskRunner.requestNextRun();
                    } else {
                        this.cancel();
                        subscriber.onError(new IllegalArgumentException("Subscriber requested a non-positive number " + n));
                    }
                }

                @Override
                public void cancel() {
                    if (StreamingHttpResultPublisher.this.subscriptionCanceled.compareAndSet(false, true)) {
                        DataPublisher.this.taskRunner.cancel();
                    }
                }
            });
        }

        @Override
        public void onNext(byte[] item) {
            this.contentQueue.offer(item);
            this.taskRunner.requestNextRun();
        }

        @Override
        public void onError(Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception e;
                this.pendingError = e = (Exception)throwable;
            } else {
                ExceptionsHelper.maybeError((Throwable)throwable).ifPresent(ExceptionsHelper::maybeDieOnAnotherThread);
                this.pendingError = new RuntimeException("Unhandled error while streaming");
            }
            this.taskRunner.requestNextRun();
        }

        @Override
        public void onComplete() {
            this.completed = true;
            this.taskRunner.requestNextRun();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            assert (false) : "Apache never calls this.";
            throw new UnsupportedOperationException("Apache never calls this.");
        }
    }

    private static class ApacheClientBackpressure {
        private final HttpSettings settings;
        private final AtomicLong bytesInQueue = new AtomicLong(0L);
        private final Object ioLock = new Object();
        private volatile IOControl savedIoControl;

        private ApacheClientBackpressure(HttpSettings settings) {
            this.settings = settings;
        }

        private void addBytesAndMaybePause(long count, IOControl ioControl) {
            if (this.bytesInQueue.addAndGet(count) >= this.settings.getMaxResponseSize().getBytes()) {
                this.pauseProducer(ioControl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pauseProducer(IOControl ioControl) {
            ioControl.suspendInput();
            Object object = this.ioLock;
            synchronized (object) {
                this.savedIoControl = ioControl;
            }
        }

        private void subtractBytesAndMaybeUnpause(long count) {
            double maxBytes;
            long currentBytesInQueue = this.bytesInQueue.updateAndGet(current -> Long.max(0L, current - count));
            if (this.savedIoControl != null && (double)currentBytesInQueue <= (maxBytes = (double)this.settings.getMaxResponseSize().getBytes() * 0.5)) {
                this.resumeProducer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resumeProducer() {
            Object object = this.ioLock;
            synchronized (object) {
                if (this.savedIoControl != null) {
                    this.savedIoControl.requestInput();
                    this.savedIoControl = null;
                }
            }
        }
    }
}

