/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public abstract class DelegatingProcessor<T, R>
implements Flow.Processor<T, R> {
    private static final Logger log = LogManager.getLogger(DelegatingProcessor.class);
    private final AtomicLong pendingRequests = new AtomicLong();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private Flow.Subscriber<? super R> downstream;
    private Flow.Subscription upstream;

    public static <ParsedChunk> Deque<ParsedChunk> parseEvent(Deque<ServerSentEvent> item, ParseChunkFunction<ParsedChunk> parseFunction, XContentParserConfiguration parserConfig) {
        ArrayDeque results = new ArrayDeque(item.size());
        for (ServerSentEvent event : item) {
            if (!event.hasData()) continue;
            Stream<ParsedChunk> delta = parseFunction.apply(parserConfig, event);
            delta.forEach(results::offer);
        }
        return results;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        if (this.downstream != null) {
            subscriber.onError(new IllegalStateException("Another subscriber is already subscribed."));
            return;
        }
        Flow.Subscription subscription = this.forwardingSubscription();
        try {
            this.downstream = subscriber;
            this.downstream.onSubscribe(subscription);
        }
        catch (Exception e) {
            log.atDebug().withThrowable((Throwable)e).log("Another publisher is already publishing to subscriber, canceling.");
            subscription.cancel();
            this.downstream = null;
            throw e;
        }
    }

    private Flow.Subscription forwardingSubscription() {
        return new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (DelegatingProcessor.this.isClosed.get()) {
                    DelegatingProcessor.this.downstream.onComplete();
                } else if (DelegatingProcessor.this.upstream != null) {
                    DelegatingProcessor.this.upstreamRequest(n);
                } else {
                    DelegatingProcessor.this.pendingRequests.accumulateAndGet(n, Long::sum);
                }
            }

            @Override
            public void cancel() {
                if (DelegatingProcessor.this.isClosed.compareAndSet(false, true) && DelegatingProcessor.this.upstream != null) {
                    DelegatingProcessor.this.upstream.cancel();
                    DelegatingProcessor.this.onCancel();
                }
            }
        };
    }

    protected void upstreamRequest(long n) {
        this.upstream.request(n);
    }

    protected void onCancel() {
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.upstream != null) {
            throw new IllegalStateException("Another upstream already exists. This subscriber can only subscribe to one publisher.");
        }
        if (this.isClosed.get()) {
            subscription.cancel();
            return;
        }
        this.upstream = subscription;
        long currentRequestCount = this.pendingRequests.getAndSet(0L);
        if (currentRequestCount != 0L) {
            this.upstream.request(currentRequestCount);
        }
    }

    @Override
    public void onNext(T item) {
        if (this.isClosed.get()) {
            this.upstream.cancel();
        } else {
            try {
                this.next(item);
            }
            catch (Exception e) {
                this.upstream().cancel();
                this.onError(e);
            }
        }
    }

    protected abstract void next(T var1) throws Exception;

    @Override
    public void onError(Throwable throwable) {
        if (this.isClosed.compareAndSet(false, true)) {
            if (this.downstream != null) {
                this.downstream.onError(throwable);
            } else {
                log.atDebug().withThrowable(throwable).log("onError was called before the downstream subscription, rethrowing to close listener.");
                throw new IllegalStateException("onError was called before the downstream subscription", throwable);
            }
        }
    }

    @Override
    public void onComplete() {
        if (this.isClosed.compareAndSet(false, true) && this.downstream != null) {
            this.downstream.onComplete();
        }
    }

    protected Flow.Subscriber<? super R> downstream() {
        return this.downstream;
    }

    protected Flow.Subscription upstream() {
        return this.upstream;
    }

    @FunctionalInterface
    public static interface ParseChunkFunction<ParsedChunk> {
        public Stream<ParsedChunk> apply(XContentParserConfiguration var1, ServerSentEvent var2);
    }
}

