/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.chunking;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.chunking.ChunkingSettingsOptions;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class WordBoundaryChunkingSettings
implements ChunkingSettings {
    public static final String NAME = "WordBoundaryChunkingSettings";
    private static final ChunkingStrategy STRATEGY = ChunkingStrategy.WORD;
    private static final int MAX_CHUNK_SIZE_LOWER_LIMIT = 10;
    private static final int MAX_CHUNK_SIZE_UPPER_LIMIT = 300;
    private static final Set<String> VALID_KEYS = Set.of(ChunkingSettingsOptions.STRATEGY.toString(), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), ChunkingSettingsOptions.OVERLAP.toString());
    protected final int maxChunkSize;
    protected final int overlap;

    public WordBoundaryChunkingSettings(Integer maxChunkSize, Integer overlap) {
        this.maxChunkSize = maxChunkSize;
        this.overlap = overlap;
    }

    public WordBoundaryChunkingSettings(StreamInput in) throws IOException {
        this.maxChunkSize = in.readInt();
        this.overlap = in.readInt();
    }

    public Map<String, Object> asMap() {
        return Map.of(ChunkingSettingsOptions.STRATEGY.toString(), STRATEGY.toString().toLowerCase(Locale.ROOT), ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize, ChunkingSettingsOptions.OVERLAP.toString(), this.overlap);
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public int overlap() {
        return this.overlap;
    }

    public static WordBoundaryChunkingSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        Object[] invalidSettings = map.keySet().stream().filter(key -> !VALID_KEYS.contains(key)).toArray();
        if (invalidSettings.length > 0) {
            validationException.addValidationError(Strings.format((String)"Word based chunking settings can not have the following settings: %s", (Object[])new Object[]{Arrays.toString(invalidSettings)}));
        }
        Integer maxChunkSize = ServiceUtils.extractRequiredPositiveIntegerBetween(map, ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), 10, 300, "chunking_settings", validationException);
        Integer overlap = null;
        if (maxChunkSize != null) {
            overlap = ServiceUtils.extractRequiredPositiveIntegerLessThanOrEqualToMax(map, ChunkingSettingsOptions.OVERLAP.toString(), maxChunkSize / 2, "chunking_settings", validationException);
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new WordBoundaryChunkingSettings(maxChunkSize, overlap);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ChunkingSettingsOptions.STRATEGY.toString(), (Enum)STRATEGY);
        builder.field(ChunkingSettingsOptions.MAX_CHUNK_SIZE.toString(), this.maxChunkSize);
        builder.field(ChunkingSettingsOptions.OVERLAP.toString(), this.overlap);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_16_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.maxChunkSize);
        out.writeInt(this.overlap);
    }

    public ChunkingStrategy getChunkingStrategy() {
        return STRATEGY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WordBoundaryChunkingSettings that = (WordBoundaryChunkingSettings)o;
        return Objects.equals(this.maxChunkSize, that.maxChunkSize) && Objects.equals(this.overlap, that.overlap);
    }

    public int hashCode() {
        return Objects.hash(this.maxChunkSize, this.overlap);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

