/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action.task;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

class FlowTask
extends CancellableTask {
    private final AtomicReference<FlowStatus> flowStatus = new AtomicReference<FlowStatus>(FlowStatus.CONNECTING);

    FlowTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers) {
        super(id, type, action, description, parentTaskId, headers);
    }

    public Task.Status getStatus() {
        return this.flowStatus.get();
    }

    public void updateStatus(FlowStatus status) {
        this.flowStatus.set(status);
    }

    static enum FlowStatus implements Task.Status
    {
        CONNECTING("Connecting"),
        CONNECTED("Connected");

        static final String NAME = "streaming_task_manager_flow_status";
        static final Writeable.Reader<FlowStatus> STREAM_READER;
        private final String status;

        private FlowStatus(String status) {
            this.status = status;
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.status);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("status", this.status).endObject();
        }

        static {
            STREAM_READER = in -> FlowStatus.valueOf(in.readString());
        }
    }
}

