/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeRegistry;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateEsField;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.type.TextEsField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public abstract class Types {
    public static Map<String, EsField> fromEs(DataTypeRegistry typeRegistry, Map<String, Object> asMap) {
        Map props = null;
        if (asMap != null && !asMap.isEmpty()) {
            props = (Map)asMap.get("properties");
        }
        return props == null || props.isEmpty() ? Collections.emptyMap() : Types.startWalking(typeRegistry, props);
    }

    private static Map<String, EsField> startWalking(DataTypeRegistry typeRegistry, Map<String, Object> mapping) {
        LinkedHashMap<String, EsField> types = new LinkedHashMap<String, EsField>();
        if (mapping == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry<String, Object> entry : mapping.entrySet()) {
            Types.walkMapping(typeRegistry, entry.getKey(), entry.getValue(), types);
        }
        return types;
    }

    private static DataType getType(DataTypeRegistry typeRegistry, Map<String, Object> content) {
        if (content.containsKey("type")) {
            TimeSeriesParams.MetricType metricType;
            String typeName = content.get("type").toString();
            if ("constant_keyword".equals(typeName) || "wildcard".equals(typeName)) {
                return DataTypes.KEYWORD;
            }
            Object metricsTypeParameter = content.get("time_series_metric");
            if (metricsTypeParameter instanceof String) {
                String str = (String)metricsTypeParameter;
                metricType = TimeSeriesParams.MetricType.fromString((String)str);
            } else {
                metricType = (TimeSeriesParams.MetricType)metricsTypeParameter;
            }
            try {
                return typeRegistry.fromEs(typeName, metricType);
            }
            catch (IllegalArgumentException ex) {
                return DataTypes.UNSUPPORTED;
            }
        }
        if (content.containsKey("properties")) {
            return DataTypes.OBJECT;
        }
        return DataTypes.UNSUPPORTED;
    }

    private static void walkMapping(DataTypeRegistry typeRegistry, String name, Object value, Map<String, EsField> mapping) {
        EsField field;
        if (value instanceof Map) {
            Object fields;
            Map content = (Map)value;
            DataType esDataType = Types.getType(typeRegistry, content);
            Map<String, EsField> properties = esDataType == DataTypes.OBJECT || esDataType == DataTypes.NESTED ? Types.fromEs(typeRegistry, content) : (content.containsKey("fields") ? ((fields = content.get("fields")) instanceof Map ? Types.startWalking(typeRegistry, (Map)fields) : Collections.emptyMap()) : Types.fromEs(typeRegistry, content));
            boolean docValues = Types.boolSetting(content.get("doc_values"), esDataType.hasDocValues());
            if (esDataType == DataTypes.TEXT) {
                field = new TextEsField(name, properties, docValues);
            } else if (esDataType == DataTypes.KEYWORD) {
                int length = Types.intSetting(content.get("ignore_above"), Short.MAX_VALUE);
                boolean normalized = Strings.hasText((String)Types.textSetting(content.get("normalizer"), null));
                field = new KeywordEsField(name, properties, docValues, length, normalized);
            } else if (esDataType == DataTypes.DATETIME) {
                field = DateEsField.dateEsField(name, properties, docValues);
            } else if (esDataType == DataTypes.UNSUPPORTED) {
                String type = content.get("type").toString();
                field = new UnsupportedEsField(name, type, null, properties);
                Types.propagateUnsupportedType(name, type, properties);
            } else {
                field = new EsField(name, esDataType, properties, docValues);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized mapping " + String.valueOf(value));
        }
        mapping.put(name, field);
    }

    private static String textSetting(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    private static boolean boolSetting(Object value, boolean defaultValue) {
        return value == null ? defaultValue : Booleans.parseBoolean((String)value.toString(), (boolean)defaultValue);
    }

    private static int intSetting(Object value, int defaultValue) {
        return value == null ? defaultValue : Integer.parseInt(value.toString());
    }

    public static void propagateUnsupportedType(String inherited, String originalType, Map<String, EsField> properties) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, EsField> entry : properties.entrySet()) {
                UnsupportedEsField u;
                EsField field = entry.getValue();
                if (field instanceof UnsupportedEsField) {
                    u = (UnsupportedEsField)field;
                    u = new UnsupportedEsField(u.getName(), originalType, inherited, u.getProperties());
                } else {
                    u = new UnsupportedEsField(field.getName(), originalType, inherited, field.getProperties());
                }
                entry.setValue(u);
                Types.propagateUnsupportedType(inherited, originalType, u.getProperties());
            }
        }
    }
}

