/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.type;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class DataType {
    private final String typeName;
    private final String name;
    private final String esType;
    private final int size;
    private final boolean isInteger;
    private final boolean isRational;
    private final boolean docValues;

    public DataType(String esName, int size, boolean isInteger, boolean isRational, boolean hasDocValues) {
        this(null, esName, size, isInteger, isRational, hasDocValues);
    }

    public DataType(String typeName, String esType, int size, boolean isInteger, boolean isRational, boolean hasDocValues) {
        String typeString = typeName != null ? typeName : esType;
        this.typeName = typeString.toLowerCase(Locale.ROOT);
        this.name = typeString.toUpperCase(Locale.ROOT);
        this.esType = esType;
        this.size = size;
        this.isInteger = isInteger;
        this.isRational = isRational;
        this.docValues = hasDocValues;
    }

    public String name() {
        return this.name;
    }

    public String typeName() {
        return this.typeName;
    }

    public String esType() {
        return this.esType;
    }

    public ScriptSortBuilder.ScriptSortType scriptSortType() {
        return this.isNumeric() ? ScriptSortBuilder.ScriptSortType.NUMBER : (this == DataTypes.VERSION ? ScriptSortBuilder.ScriptSortType.VERSION : ScriptSortBuilder.ScriptSortType.STRING);
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isRational() {
        return this.isRational;
    }

    public boolean isNumeric() {
        return this.isInteger || this.isRational;
    }

    public int size() {
        return this.size;
    }

    public boolean hasDocValues() {
        return this.docValues;
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.esType, this.size, this.isInteger, this.isRational, this.docValues);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        return Objects.equals(this.typeName, other.typeName) && Objects.equals(this.esType, other.esType) && this.size == other.size && this.isInteger == other.isInteger && this.isRational == other.isRational && this.docValues == other.docValues;
    }

    public String toString() {
        return this.name;
    }
}

