/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xpack.ql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class QueryStringQuery
extends LeafQuery {
    private static final Map<String, BiConsumer<QueryStringQueryBuilder, String>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(QueryStringQueryBuilder.ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), (qb, s) -> qb.allowLeadingWildcard(Boolean.valueOf(Booleans.parseBoolean((String)s)))), Map.entry(QueryStringQueryBuilder.ANALYZE_WILDCARD_FIELD.getPreferredName(), (qb, s) -> qb.analyzeWildcard(Boolean.valueOf(Booleans.parseBoolean((String)s)))), Map.entry(QueryStringQueryBuilder.ANALYZER_FIELD.getPreferredName(), QueryStringQueryBuilder::analyzer), Map.entry(QueryStringQueryBuilder.GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s))), Map.entry(QueryStringQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), QueryStringQueryBuilder::defaultField), Map.entry(QueryStringQueryBuilder.DEFAULT_OPERATOR_FIELD.getPreferredName(), (qb, s) -> qb.defaultOperator(Operator.fromString((String)s))), Map.entry(QueryStringQueryBuilder.ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), (qb, s) -> qb.enablePositionIncrements(Booleans.parseBoolean((String)s))), Map.entry(QueryStringQueryBuilder.ESCAPE_FIELD.getPreferredName(), (qb, s) -> qb.escape(Booleans.parseBoolean((String)s))), Map.entry(QueryStringQueryBuilder.FUZZINESS_FIELD.getPreferredName(), (qb, s) -> qb.fuzziness(Fuzziness.fromString((String)s))), Map.entry(QueryStringQueryBuilder.FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), (qb, s) -> qb.fuzzyMaxExpansions(Integer.parseInt(s))), Map.entry(QueryStringQueryBuilder.FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), (qb, s) -> qb.fuzzyPrefixLength(Integer.parseInt(s))), Map.entry(QueryStringQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), QueryStringQueryBuilder::fuzzyRewrite), Map.entry(QueryStringQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s))), Map.entry(QueryStringQueryBuilder.LENIENT_FIELD.getPreferredName(), (qb, s) -> qb.lenient(Boolean.valueOf(Booleans.parseBoolean((String)s)))), Map.entry(QueryStringQueryBuilder.MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), (qb, s) -> qb.maxDeterminizedStates(Integer.parseInt(s))), Map.entry(QueryStringQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), QueryStringQueryBuilder::minimumShouldMatch), Map.entry(QueryStringQueryBuilder.PHRASE_SLOP_FIELD.getPreferredName(), (qb, s) -> qb.phraseSlop(Integer.parseInt(s))), Map.entry(QueryStringQueryBuilder.REWRITE_FIELD.getPreferredName(), QueryStringQueryBuilder::rewrite), Map.entry(QueryStringQueryBuilder.QUOTE_ANALYZER_FIELD.getPreferredName(), QueryStringQueryBuilder::quoteAnalyzer), Map.entry(QueryStringQueryBuilder.QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), QueryStringQueryBuilder::quoteFieldSuffix), Map.entry(QueryStringQueryBuilder.TIE_BREAKER_FIELD.getPreferredName(), (qb, s) -> qb.tieBreaker(Float.parseFloat(s))), Map.entry(QueryStringQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), QueryStringQueryBuilder::timeZone), Map.entry(QueryStringQueryBuilder.TYPE_FIELD.getPreferredName(), (qb, s) -> qb.type(MultiMatchQueryBuilder.Type.parse((String)s, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE))));
    private final String query;
    private final Map<String, Float> fields;
    private final StringQueryPredicate predicate;
    private final Map<String, String> options;

    public QueryStringQuery(Source source, String query, String fieldName) {
        this(source, query, Collections.singletonMap(fieldName, Float.valueOf(1.0f)), null);
    }

    public QueryStringQuery(Source source, String query, Map<String, Float> fields, StringQueryPredicate predicate) {
        super(source);
        this.query = query;
        this.fields = fields;
        this.predicate = predicate;
        this.options = predicate == null ? Collections.emptyMap() : predicate.optionMap();
    }

    @Override
    public QueryBuilder asBuilder() {
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery((String)this.query);
        queryBuilder.fields(this.fields);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal query_string option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public Map<String, Float> fields() {
        return this.fields;
    }

    public String query() {
        return this.query;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.fields, this.predicate);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryStringQuery other = (QueryStringQuery)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.fields, other.fields) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    protected String innerToString() {
        return String.valueOf(this.fields) + ":" + this.query;
    }
}

