/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.logical;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.logical.NotProcessor;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Not
extends UnaryScalarFunction
implements Negatable<Expression> {
    public Not(Source source, Expression child) {
        super(source, child);
    }

    @Override
    protected NodeInfo<Not> info() {
        return NodeInfo.create(this, Not::new, this.field());
    }

    @Override
    protected Not replaceChild(Expression newChild) {
        return new Not(this.source(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (DataTypes.BOOLEAN == this.field().dataType()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isBoolean(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public Object fold() {
        return NotProcessor.INSTANCE.process(this.field().fold());
    }

    @Override
    protected Processor makeProcessor() {
        return NotProcessor.INSTANCE;
    }

    @Override
    public String processScript(String script) {
        return Scripts.formatTemplate("{ql}.not(" + script + ")");
    }

    @Override
    protected Expression canonicalize() {
        if (this.field() instanceof Negatable) {
            return ((Expression)((Negatable)((Object)this.field())).negate()).canonical();
        }
        return super.canonicalize();
    }

    @Override
    public Expression negate() {
        return this.field();
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    static Expression negate(Expression exp) {
        return exp instanceof Negatable ? ((Negatable)((Object)exp)).negate() : new Not(exp.source(), exp);
    }
}

