/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineBucketedSort;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;
import org.elasticsearch.xpack.spatial.search.aggregations.TimeSeriesGeoLineBuckets;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoLineMultiValuesSource;

abstract class GeoLineAggregator
extends MetricsAggregator {
    protected final GeoLineMultiValuesSource valuesSources;
    protected final boolean includeSorts;
    protected final SortOrder sortOrder;
    protected final int size;

    private GeoLineAggregator(String name, GeoLineMultiValuesSource valuesSources, AggregationContext context, Aggregator parent, Map<String, Object> metaData, boolean includeSorts, SortOrder sortOrder, int size) throws IOException {
        super(name, context, parent, metaData);
        this.valuesSources = valuesSources;
        this.includeSorts = includeSorts;
        this.sortOrder = sortOrder;
        this.size = size;
    }

    public ScoreMode scoreMode() {
        if (this.valuesSources != null && this.valuesSources.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoLine(this.name, new long[0], new double[0], this.metadata(), true, this.includeSorts, this.sortOrder, this.size, true, false);
    }

    static class TimeSeries
    extends GeoLineAggregator {
        private final TimeSeriesGeoLineBuckets geolineBuckets;

        TimeSeries(String name, GeoLineMultiValuesSource valuesSources, AggregationContext context, Aggregator parent, Map<String, Object> metaData, boolean includeSorts, SortOrder sortOrder, int size) throws IOException {
            super(name, valuesSources, context, parent, metaData, includeSorts, sortOrder, size);
            this.geolineBuckets = new TimeSeriesGeoLineBuckets(size, valuesSources, this::makeGeoline, x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        }

        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            final TimeSeriesGeoLineBuckets.Leaf leaf = this.geolineBuckets.forLeaf(aggCtx);
            return new LeafBucketCollector(){

                public void collect(int doc, long bucket) throws IOException {
                    leaf.collect(doc, bucket);
                }
            };
        }

        private InternalGeoLine makeGeoline() {
            return this.geolineBuckets.buildInternalGeoLine(this.name, this.metadata(), this.includeSorts, this.sortOrder);
        }

        public InternalAggregation buildAggregation(long bucket) {
            return this.geolineBuckets.getGeolineForBucket(bucket);
        }

        protected void doPostCollection() {
            this.geolineBuckets.doPostCollection();
        }

        public void doClose() {
            super.doClose();
            Releasables.close((Releasable)this.geolineBuckets);
        }
    }

    static class Normal
    extends GeoLineAggregator {
        protected final BigArrays bigArrays;
        protected LongArray counts;
        private final GeoLineBucketedSort sort;
        private final GeoLineBucketedSort.Extra extra;

        Normal(String name, GeoLineMultiValuesSource valuesSources, AggregationContext context, Aggregator parent, Map<String, Object> metaData, boolean includeSorts, SortOrder sortOrder, int size) throws IOException {
            super(name, valuesSources, context, parent, metaData, includeSorts, sortOrder, size);
            this.bigArrays = context.bigArrays();
            this.extra = new GeoLineBucketedSort.Extra(this.bigArrays, valuesSources);
            this.sort = new GeoLineBucketedSort(this.bigArrays, sortOrder, null, size, valuesSources, this.extra);
            this.counts = this.bigArrays.newLongArray(1L, true);
        }

        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            final BucketedSort.Leaf leafSort = this.sort.forLeaf(aggCtx.getLeafReaderContext());
            return new LeafBucketCollector(){

                public void collect(int doc, long bucket) throws IOException {
                    leafSort.collect(doc, bucket);
                    counts = bigArrays.grow(counts, bucket + 1L);
                    counts.increment(bucket, 1L);
                }
            };
        }

        public InternalAggregation buildAggregation(long bucket) {
            if (bucket >= this.counts.size()) {
                return this.buildEmptyAggregation();
            }
            boolean complete = this.counts.get(bucket) <= (long)this.size;
            return this.sort.buildAggregation(bucket, this.name, this.metadata(), complete, this.includeSorts, this.size, x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        }

        public void doClose() {
            super.doClose();
            Releasables.close((Releasable[])new Releasable[]{this.counts, this.sort, this.extra});
        }
    }

    static class Empty
    extends GeoLineAggregator {
        Empty(String name, AggregationContext context, Aggregator parent, Map<String, Object> metaData, boolean includeSorts, SortOrder sortOrder, int size) throws IOException {
            super(name, null, context, parent, metaData, includeSorts, sortOrder, size);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }

        public InternalAggregation buildAggregation(long bucket) {
            return this.buildEmptyAggregation();
        }
    }
}

